#pragma once

#include "FormMapping.h"

namespace PcanIsoTpExample {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Collections::Generic;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Text;
	using namespace System::Threading;

	using namespace Peak::Can::IsoTp;

	/// <summary>
	/// Main application that demonstrates ISO-TP API features.
	/// </summary>
	public ref class FormMain : public System::Windows::Forms::Form
	{
#pragma region Delegates
	public:
		/// <summary>
		/// Declare a delegate type to read CANTP messages
		/// </summary>
		delegate void ReadDelegateHandler();
		/// <summary>
		/// Declare a delegate type to handle failure while reading CANTP messages
		/// </summary>
		delegate void ReadFailedDelegateHandler(TPCANTPStatus sts);
#pragma endregion

#pragma region Members
	private:
		/// <summary>
		/// Handles of all currently available PCAN-Hardwares.
		/// </summary>
		array<TPCANTPHandle> ^m_pctpHandles;
		/// <summary>
		/// Connected PCAN ISO-TP Handle (PCANTP_NONEBUS if not connected).
		/// </summary>
		TPCANTPHandle m_pctpHandle;
		/// <summary>
		/// DialogBox that handles mapping.
		/// </summary>
		FormMapping ^m_dlgMapping;
		/// <summary>
		/// List of configured PCAN-ISO-TP mappings.
		/// </summary>
		List<MappingStatus^> ^m_mappings;
		/// <summary>
		/// Collection of MessageStatus used to display each received ISO-TP messages.
		/// </summary>
		System::Collections::ArrayList ^m_receiveMsgs;
		/// <summary>
		/// "Receive CANTP message" Event.
		/// </summary>
		System::Threading::AutoResetEvent ^m_receiveEvent;
		/// <summary>
		/// Read Delegate to read CANTP messages.
		/// </summary>
		ReadDelegateHandler ^m_readDelegate;
		/// <summary>
		/// Read Delegate to read CANTP messages.
		/// </summary>
		ReadFailedDelegateHandler ^m_readFailedDelegate;
		/// <summary>
		/// Thread used to read CANTP messages via events.
		/// </summary>
		System::Threading::Thread ^m_readThread;
#if _DEBUG_WRITE_CHECK_FILE
		/// <summary>
		/// Global variable used to know if check file initialization is done
		/// </summary>
		static bool g_FileInitAlreadyDone = false;
		/// <summary>
		/// Global File object
		/// </summary>
		static System::IO::StreamWriter^ g_CheckFileToWrite;
#endif



	private: System::Windows::Forms::Button^  buttonMappingSave;
	private: System::Windows::Forms::Label^  labelConnBitRate;

	private: System::Windows::Forms::Label^  labelConnBaudrate;
	private: System::Windows::Forms::TextBox^  textBoxCanFdBitrate;

	private: System::Windows::Forms::CheckBox^  checkBoxCanFd;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownPriority;
	private: System::Windows::Forms::CheckBox^  checkBoxHasPriority;
	private: System::Windows::Forms::CheckBox^  checkBoxBRS;
	private: System::Windows::Forms::CheckBox^  checkBoxFDMessage;
	private: System::Windows::Forms::Button^  buttonMappingLoad;


#pragma endregion

			 /// <summary>
			 /// Default constructor
			 /// </summary>
	public:
		FormMain(void)
		{
			InitializeComponent();

			// Asserts PCAN-ISO-TP library is available.
			try
			{
				StringBuilder^ buf = gcnew StringBuilder(256);
				TPCANTPStatus sts;
				// Get API version
				sts = CanTpApi::GetValue(CanTpApi::PCANTP_NONEBUS, TPCANTPParameter::PCANTP_PARAM_API_VERSION, buf, (UInt32)buf->Capacity);
				Console::WriteLine("PCAN-ISO-TP API version: {0}", buf);
				checkCanTpStatus(CanTpApi::PCANTP_NONEBUS, sts, buf, TPCANTPParameter::PCANTP_PARAM_API_VERSION);
			}
			catch (DllNotFoundException^)
			{
				MessageBox::Show("Unable to find one of required PCAN libraries: PCANBasic.dll or PCAN-ISO-TP.dll.", "Error!",
					MessageBoxButtons::OK, MessageBoxIcon::Error);
				Environment::Exit(-1);
			}
			// Creates an array with all possible PCAN-ISO-TP Channels.
			m_pctpHandles = gcnew array<TPCANTPHandle>
			{
				CanTpApi::PCANTP_ISABUS1,
					CanTpApi::PCANTP_ISABUS2,
					CanTpApi::PCANTP_ISABUS3,
					CanTpApi::PCANTP_ISABUS4,
					CanTpApi::PCANTP_ISABUS5,
					CanTpApi::PCANTP_ISABUS6,
					CanTpApi::PCANTP_ISABUS7,
					CanTpApi::PCANTP_ISABUS8,
					CanTpApi::PCANTP_DNGBUS1,
					CanTpApi::PCANTP_PCIBUS1,
					CanTpApi::PCANTP_PCIBUS2,
					CanTpApi::PCANTP_PCIBUS3,
					CanTpApi::PCANTP_PCIBUS4,
					CanTpApi::PCANTP_PCIBUS5,
					CanTpApi::PCANTP_PCIBUS6,
					CanTpApi::PCANTP_PCIBUS7,
					CanTpApi::PCANTP_PCIBUS8,
					CanTpApi::PCANTP_PCIBUS9,
					CanTpApi::PCANTP_PCIBUS10,
					CanTpApi::PCANTP_PCIBUS11,
					CanTpApi::PCANTP_PCIBUS12,
					CanTpApi::PCANTP_PCIBUS13,
					CanTpApi::PCANTP_PCIBUS14,
					CanTpApi::PCANTP_PCIBUS15,
					CanTpApi::PCANTP_PCIBUS16,
					CanTpApi::PCANTP_USBBUS1,
					CanTpApi::PCANTP_USBBUS2,
					CanTpApi::PCANTP_USBBUS3,
					CanTpApi::PCANTP_USBBUS4,
					CanTpApi::PCANTP_USBBUS5,
					CanTpApi::PCANTP_USBBUS6,
					CanTpApi::PCANTP_USBBUS7,
					CanTpApi::PCANTP_USBBUS8,
					CanTpApi::PCANTP_USBBUS9,
					CanTpApi::PCANTP_USBBUS10,
					CanTpApi::PCANTP_USBBUS11,
					CanTpApi::PCANTP_USBBUS12,
					CanTpApi::PCANTP_USBBUS13,
					CanTpApi::PCANTP_USBBUS14,
					CanTpApi::PCANTP_USBBUS15,
					CanTpApi::PCANTP_USBBUS16,
					CanTpApi::PCANTP_PCCBUS1,
					CanTpApi::PCANTP_PCCBUS2,
					CanTpApi::PCANTP_LANBUS1,
					CanTpApi::PCANTP_LANBUS2,
					CanTpApi::PCANTP_LANBUS3,
					CanTpApi::PCANTP_LANBUS4,
					CanTpApi::PCANTP_LANBUS5,
					CanTpApi::PCANTP_LANBUS6,
					CanTpApi::PCANTP_LANBUS7,
					CanTpApi::PCANTP_LANBUS8,
					CanTpApi::PCANTP_LANBUS9,
					CanTpApi::PCANTP_LANBUS10,
					CanTpApi::PCANTP_LANBUS11,
					CanTpApi::PCANTP_LANBUS12,
					CanTpApi::PCANTP_LANBUS13,
					CanTpApi::PCANTP_LANBUS14,
					CanTpApi::PCANTP_LANBUS15,
					CanTpApi::PCANTP_LANBUS16,
			};
			// Initializes array of received ISO-TP messages
			m_receiveMsgs = gcnew System::Collections::ArrayList();
			// Initializes list of configured mappings
			m_mappings = gcnew List<MappingStatus^>();
			// Creates the delegate used to message reading
			m_readDelegate = gcnew ReadDelegateHandler(this, &FormMain::readMessages);
			// Creates the delegate used when reading-thread fails
			m_readFailedDelegate = gcnew ReadFailedDelegateHandler(this, &FormMain::readThreadFailed);
			// Creates the event used to signalize incomming messages 
			m_receiveEvent = gcnew System::Threading::AutoResetEvent(false);

			// Initializes UI components
			initializeUiConnection();
			initializeUiTabMessages();
			initializeUiTabParameters();
			// Initializes the "mapping" dialog once and for all
			m_dlgMapping = gcnew FormMapping();
			textBoxCanFdBitrate->Text = "f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1";
			checkBoxCanFd_CheckedChanged(this, nullptr); // initialization of UI components for FD messages
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~FormMain()
		{
			if (components)
			{
				delete components;
			}
		}

#pragma region Windows Form Designer Members Generated Code
		/// <summary>
		/// Required designer variable.
		/// </summary>
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingMsgType;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgLen;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgResult;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgTargetType;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgFormat;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgType;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgIdType;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgRemoteAddr;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgTargetAddr;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgSourceAddr;
	private: System::Windows::Forms::CheckBox^  checkBoxMsgShowPeriod;
	private: System::Windows::Forms::RadioButton^  radioButtonMsgManual;
	private: System::Windows::Forms::RadioButton^  radioButtonMsgEvent;
	private: System::Windows::Forms::ListView^  listViewMsgs;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgCount;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgTimestamp;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMsgData;
	private: System::Windows::Forms::GroupBox^  groupBoxMsgRead;
	private: System::Windows::Forms::Button^  buttonMsgClear;
	private: System::Windows::Forms::RadioButton^  radioButtonMsgTimer;
	private: System::Windows::Forms::Button^  buttonMsgRead;
	private: System::Windows::Forms::TabPage^  tabPageMessages;
	private: System::Windows::Forms::GroupBox^  groupBoxMsgWrite;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownRemoteAddr;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownTargetAddr;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownSourceAddr;
	private: System::Windows::Forms::Button^  buttonMsgDataFill;
	private: System::Windows::Forms::Label^  labelMsgRemoteAddr;
	private: System::Windows::Forms::Label^  labelMsgTargetAddr;
	private: System::Windows::Forms::TextBox^  textBoxMsgData;
	private: System::Windows::Forms::Label^  labelMsgMapping;
	private: System::Windows::Forms::ComboBox^  comboBoxMsgMapping;
	private: System::Windows::Forms::Label^  labelMsgData;
	private: System::Windows::Forms::Button^  buttonMsgWrite;
	private: System::Windows::Forms::Label^  labelMsgLength;
	private: System::Windows::Forms::Label^  labelMsgSourceAddr;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownMsgLength;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingRemoteAddr;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingFormat;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingTargetAddr;
	private: System::Windows::Forms::Timer^  timerRead;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingSourceAddr;
	private: System::Windows::Forms::Button^  buttonParamVersion;
	private: System::Windows::Forms::ComboBox^  comboBoxHwType;
	private: System::Windows::Forms::ComboBox^  comboBoxInterrupt;
	private: System::Windows::Forms::Label^  labelConnInterrupt;
	private: System::Windows::Forms::ComboBox^  comboBoxIoPort;
	private: System::Windows::Forms::Label^  labelConnIoPort;
	private: System::Windows::Forms::Label^  labelConnHwType;
	private: System::Windows::Forms::ComboBox^  comboBoxBaudrate;

	private: System::Windows::Forms::Button^  buttonParamReset;
	private: System::Windows::Forms::GroupBox^  groupBoxParamInfo;
	private: System::Windows::Forms::Button^  buttonParamStatus;
	private: System::Windows::Forms::ListBox^  listBoxParamInfo;
	private: System::Windows::Forms::Button^  buttonParamInfoClear;
	private: System::Windows::Forms::TabPage^  tabPageParameters;
	private: System::Windows::Forms::GroupBox^  groupBoxParamCfg;
	private: System::Windows::Forms::Label^  labelParameter;
	private: System::Windows::Forms::ComboBox^  comboBoxParameter;
	private: System::Windows::Forms::Label^  labelParamActivation;
	private: System::Windows::Forms::RadioButton^  radioButtonParamActive;
	private: System::Windows::Forms::RadioButton^  radioButtonParamInactive;
	private: System::Windows::Forms::Label^  labelParamValue;
	private: System::Windows::Forms::NumericUpDown^  numericUpDownParamValue;
	private: System::Windows::Forms::Button^  buttonParamGet;
	private: System::Windows::Forms::Button^  buttonParamSet;
	private: System::Windows::Forms::TabControl^  tabControlMain;
	private: System::Windows::Forms::TabPage^  tabPageMappings;
	private: System::Windows::Forms::Button^  buttonMappingSample;
	private: System::Windows::Forms::Button^  buttonMappingDel;
	private: System::Windows::Forms::Button^  buttonMappingAdd;
	private: System::Windows::Forms::ListView^  listViewMappings;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingCanId;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingCanIdResponse;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingTargetType;
	private: System::Windows::Forms::ColumnHeader^  columnHeaderMappingCanIdType;
	private: System::Windows::Forms::Button^  buttonHwRefresh;
	private: System::Windows::Forms::ComboBox^  comboBoxChannel;
	private: System::Windows::Forms::Label^  labelConnHardware;
	private: System::Windows::Forms::Button^  buttonInit;
	private: System::Windows::Forms::Button^  buttonRelease;
	private: System::Windows::Forms::GroupBox^  groupBoxConnection;
	private: System::Windows::Forms::Timer^  timerDisplay;
	private: System::ComponentModel::IContainer^  components;
#pragma endregion

#pragma region Windows Form Designer generated code
			 /// <summary>
			 /// Required method for Designer support - do not modify
			 /// the contents of this method with the code editor.
			 /// </summary>
			 void InitializeComponent(void) {
				 this->components = (gcnew System::ComponentModel::Container());
				 this->columnHeaderMappingMsgType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgLen = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgResult = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgTargetType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgFormat = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgIdType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgRemoteAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgTargetAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgSourceAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->checkBoxMsgShowPeriod = (gcnew System::Windows::Forms::CheckBox());
				 this->radioButtonMsgManual = (gcnew System::Windows::Forms::RadioButton());
				 this->radioButtonMsgEvent = (gcnew System::Windows::Forms::RadioButton());
				 this->listViewMsgs = (gcnew System::Windows::Forms::ListView());
				 this->columnHeaderMsgCount = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgTimestamp = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMsgData = (gcnew System::Windows::Forms::ColumnHeader());
				 this->groupBoxMsgRead = (gcnew System::Windows::Forms::GroupBox());
				 this->buttonMsgClear = (gcnew System::Windows::Forms::Button());
				 this->radioButtonMsgTimer = (gcnew System::Windows::Forms::RadioButton());
				 this->buttonMsgRead = (gcnew System::Windows::Forms::Button());
				 this->tabPageMessages = (gcnew System::Windows::Forms::TabPage());
				 this->groupBoxMsgWrite = (gcnew System::Windows::Forms::GroupBox());
				 this->numericUpDownPriority = (gcnew System::Windows::Forms::NumericUpDown());
				 this->checkBoxHasPriority = (gcnew System::Windows::Forms::CheckBox());
				 this->checkBoxBRS = (gcnew System::Windows::Forms::CheckBox());
				 this->checkBoxFDMessage = (gcnew System::Windows::Forms::CheckBox());
				 this->numericUpDownRemoteAddr = (gcnew System::Windows::Forms::NumericUpDown());
				 this->numericUpDownTargetAddr = (gcnew System::Windows::Forms::NumericUpDown());
				 this->numericUpDownSourceAddr = (gcnew System::Windows::Forms::NumericUpDown());
				 this->buttonMsgDataFill = (gcnew System::Windows::Forms::Button());
				 this->labelMsgRemoteAddr = (gcnew System::Windows::Forms::Label());
				 this->labelMsgTargetAddr = (gcnew System::Windows::Forms::Label());
				 this->textBoxMsgData = (gcnew System::Windows::Forms::TextBox());
				 this->labelMsgMapping = (gcnew System::Windows::Forms::Label());
				 this->comboBoxMsgMapping = (gcnew System::Windows::Forms::ComboBox());
				 this->labelMsgData = (gcnew System::Windows::Forms::Label());
				 this->buttonMsgWrite = (gcnew System::Windows::Forms::Button());
				 this->labelMsgLength = (gcnew System::Windows::Forms::Label());
				 this->labelMsgSourceAddr = (gcnew System::Windows::Forms::Label());
				 this->numericUpDownMsgLength = (gcnew System::Windows::Forms::NumericUpDown());
				 this->columnHeaderMappingRemoteAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMappingFormat = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMappingTargetAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->timerRead = (gcnew System::Windows::Forms::Timer(this->components));
				 this->columnHeaderMappingSourceAddr = (gcnew System::Windows::Forms::ColumnHeader());
				 this->buttonParamVersion = (gcnew System::Windows::Forms::Button());
				 this->comboBoxHwType = (gcnew System::Windows::Forms::ComboBox());
				 this->comboBoxInterrupt = (gcnew System::Windows::Forms::ComboBox());
				 this->labelConnInterrupt = (gcnew System::Windows::Forms::Label());
				 this->comboBoxIoPort = (gcnew System::Windows::Forms::ComboBox());
				 this->labelConnIoPort = (gcnew System::Windows::Forms::Label());
				 this->labelConnHwType = (gcnew System::Windows::Forms::Label());
				 this->comboBoxBaudrate = (gcnew System::Windows::Forms::ComboBox());
				 this->buttonParamReset = (gcnew System::Windows::Forms::Button());
				 this->groupBoxParamInfo = (gcnew System::Windows::Forms::GroupBox());
				 this->buttonParamStatus = (gcnew System::Windows::Forms::Button());
				 this->listBoxParamInfo = (gcnew System::Windows::Forms::ListBox());
				 this->buttonParamInfoClear = (gcnew System::Windows::Forms::Button());
				 this->tabPageParameters = (gcnew System::Windows::Forms::TabPage());
				 this->groupBoxParamCfg = (gcnew System::Windows::Forms::GroupBox());
				 this->labelParameter = (gcnew System::Windows::Forms::Label());
				 this->comboBoxParameter = (gcnew System::Windows::Forms::ComboBox());
				 this->labelParamActivation = (gcnew System::Windows::Forms::Label());
				 this->radioButtonParamActive = (gcnew System::Windows::Forms::RadioButton());
				 this->radioButtonParamInactive = (gcnew System::Windows::Forms::RadioButton());
				 this->labelParamValue = (gcnew System::Windows::Forms::Label());
				 this->numericUpDownParamValue = (gcnew System::Windows::Forms::NumericUpDown());
				 this->buttonParamGet = (gcnew System::Windows::Forms::Button());
				 this->buttonParamSet = (gcnew System::Windows::Forms::Button());
				 this->tabControlMain = (gcnew System::Windows::Forms::TabControl());
				 this->tabPageMappings = (gcnew System::Windows::Forms::TabPage());
				 this->buttonMappingLoad = (gcnew System::Windows::Forms::Button());
				 this->buttonMappingSave = (gcnew System::Windows::Forms::Button());
				 this->buttonMappingSample = (gcnew System::Windows::Forms::Button());
				 this->buttonMappingDel = (gcnew System::Windows::Forms::Button());
				 this->buttonMappingAdd = (gcnew System::Windows::Forms::Button());
				 this->listViewMappings = (gcnew System::Windows::Forms::ListView());
				 this->columnHeaderMappingCanId = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMappingCanIdResponse = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMappingTargetType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->columnHeaderMappingCanIdType = (gcnew System::Windows::Forms::ColumnHeader());
				 this->buttonHwRefresh = (gcnew System::Windows::Forms::Button());
				 this->comboBoxChannel = (gcnew System::Windows::Forms::ComboBox());
				 this->labelConnHardware = (gcnew System::Windows::Forms::Label());
				 this->buttonInit = (gcnew System::Windows::Forms::Button());
				 this->buttonRelease = (gcnew System::Windows::Forms::Button());
				 this->groupBoxConnection = (gcnew System::Windows::Forms::GroupBox());
				 this->checkBoxCanFd = (gcnew System::Windows::Forms::CheckBox());
				 this->labelConnBaudrate = (gcnew System::Windows::Forms::Label());
				 this->labelConnBitRate = (gcnew System::Windows::Forms::Label());
				 this->textBoxCanFdBitrate = (gcnew System::Windows::Forms::TextBox());
				 this->timerDisplay = (gcnew System::Windows::Forms::Timer(this->components));
				 this->groupBoxMsgRead->SuspendLayout();
				 this->tabPageMessages->SuspendLayout();
				 this->groupBoxMsgWrite->SuspendLayout();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownPriority))->BeginInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownRemoteAddr))->BeginInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownTargetAddr))->BeginInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownSourceAddr))->BeginInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownMsgLength))->BeginInit();
				 this->groupBoxParamInfo->SuspendLayout();
				 this->tabPageParameters->SuspendLayout();
				 this->groupBoxParamCfg->SuspendLayout();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownParamValue))->BeginInit();
				 this->tabControlMain->SuspendLayout();
				 this->tabPageMappings->SuspendLayout();
				 this->groupBoxConnection->SuspendLayout();
				 this->SuspendLayout();
				 // 
				 // columnHeaderMappingMsgType
				 // 
				 this->columnHeaderMappingMsgType->Text = L"MsgType";
				 this->columnHeaderMappingMsgType->Width = 100;
				 // 
				 // columnHeaderMsgLen
				 // 
				 this->columnHeaderMsgLen->Text = L"Length";
				 this->columnHeaderMsgLen->Width = 45;
				 // 
				 // columnHeaderMsgResult
				 // 
				 this->columnHeaderMsgResult->Text = L"Result";
				 this->columnHeaderMsgResult->Width = 42;
				 // 
				 // columnHeaderMsgTargetType
				 // 
				 this->columnHeaderMsgTargetType->Text = L"Target type";
				 this->columnHeaderMsgTargetType->Width = 70;
				 // 
				 // columnHeaderMsgFormat
				 // 
				 this->columnHeaderMsgFormat->Text = L"Format";
				 this->columnHeaderMsgFormat->Width = 63;
				 // 
				 // columnHeaderMsgType
				 // 
				 this->columnHeaderMsgType->Text = L"Type";
				 this->columnHeaderMsgType->Width = 72;
				 // 
				 // columnHeaderMsgIdType
				 // 
				 this->columnHeaderMsgIdType->Text = L"ID";
				 this->columnHeaderMsgIdType->Width = 45;
				 // 
				 // columnHeaderMsgRemoteAddr
				 // 
				 this->columnHeaderMsgRemoteAddr->Text = L"Remote";
				 this->columnHeaderMsgRemoteAddr->Width = 50;
				 // 
				 // columnHeaderMsgTargetAddr
				 // 
				 this->columnHeaderMsgTargetAddr->Text = L"Target";
				 this->columnHeaderMsgTargetAddr->Width = 45;
				 // 
				 // columnHeaderMsgSourceAddr
				 // 
				 this->columnHeaderMsgSourceAddr->Text = L"Source";
				 this->columnHeaderMsgSourceAddr->Width = 50;
				 // 
				 // checkBoxMsgShowPeriod
				 // 
				 this->checkBoxMsgShowPeriod->AutoSize = true;
				 this->checkBoxMsgShowPeriod->Checked = true;
				 this->checkBoxMsgShowPeriod->CheckState = System::Windows::Forms::CheckState::Checked;
				 this->checkBoxMsgShowPeriod->Location = System::Drawing::Point(374, 15);
				 this->checkBoxMsgShowPeriod->Name = L"checkBoxMsgShowPeriod";
				 this->checkBoxMsgShowPeriod->Size = System::Drawing::Size(123, 17);
				 this->checkBoxMsgShowPeriod->TabIndex = 3;
				 this->checkBoxMsgShowPeriod->Text = L"Timestamp as period";
				 this->checkBoxMsgShowPeriod->UseVisualStyleBackColor = true;
				 this->checkBoxMsgShowPeriod->CheckedChanged += gcnew System::EventHandler(this, &FormMain::checkBoxMsgShowPeriod_CheckedChanged);
				 // 
				 // radioButtonMsgManual
				 // 
				 this->radioButtonMsgManual->AutoSize = true;
				 this->radioButtonMsgManual->Location = System::Drawing::Point(276, 14);
				 this->radioButtonMsgManual->Name = L"radioButtonMsgManual";
				 this->radioButtonMsgManual->Size = System::Drawing::Size(89, 17);
				 this->radioButtonMsgManual->TabIndex = 2;
				 this->radioButtonMsgManual->Text = L"Manual Read";
				 this->radioButtonMsgManual->UseVisualStyleBackColor = true;
				 this->radioButtonMsgManual->CheckedChanged += gcnew System::EventHandler(this, &FormMain::radioButtonMsgRead_CheckedChanged);
				 // 
				 // radioButtonMsgEvent
				 // 
				 this->radioButtonMsgEvent->AutoSize = true;
				 this->radioButtonMsgEvent->Location = System::Drawing::Point(131, 14);
				 this->radioButtonMsgEvent->Name = L"radioButtonMsgEvent";
				 this->radioButtonMsgEvent->Size = System::Drawing::Size(139, 17);
				 this->radioButtonMsgEvent->TabIndex = 1;
				 this->radioButtonMsgEvent->Text = L"Reading using an Event";
				 this->radioButtonMsgEvent->UseVisualStyleBackColor = true;
				 this->radioButtonMsgEvent->CheckedChanged += gcnew System::EventHandler(this, &FormMain::radioButtonMsgRead_CheckedChanged);
				 // 
				 // listViewMsgs
				 // 
				 this->listViewMsgs->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
					 | System::Windows::Forms::AnchorStyles::Left)
					 | System::Windows::Forms::AnchorStyles::Right));
				 this->listViewMsgs->Columns->AddRange(gcnew cli::array< System::Windows::Forms::ColumnHeader^  >(12) {
					 this->columnHeaderMsgSourceAddr,
						 this->columnHeaderMsgTargetAddr, this->columnHeaderMsgRemoteAddr, this->columnHeaderMsgIdType, this->columnHeaderMsgType, this->columnHeaderMsgFormat,
						 this->columnHeaderMsgTargetType, this->columnHeaderMsgResult, this->columnHeaderMsgLen, this->columnHeaderMsgCount, this->columnHeaderMsgTimestamp,
						 this->columnHeaderMsgData
				 });
				 this->listViewMsgs->FullRowSelect = true;
				 this->listViewMsgs->Location = System::Drawing::Point(6, 37);
				 this->listViewMsgs->MultiSelect = false;
				 this->listViewMsgs->Name = L"listViewMsgs";
				 this->listViewMsgs->Size = System::Drawing::Size(791, 128);
				 this->listViewMsgs->TabIndex = 4;
				 this->listViewMsgs->UseCompatibleStateImageBehavior = false;
				 this->listViewMsgs->View = System::Windows::Forms::View::Details;
				 // 
				 // columnHeaderMsgCount
				 // 
				 this->columnHeaderMsgCount->Text = L"Count";
				 this->columnHeaderMsgCount->Width = 50;
				 // 
				 // columnHeaderMsgTimestamp
				 // 
				 this->columnHeaderMsgTimestamp->Text = L"Timestamp";
				 this->columnHeaderMsgTimestamp->Width = 64;
				 // 
				 // columnHeaderMsgData
				 // 
				 this->columnHeaderMsgData->Text = L"Data";
				 this->columnHeaderMsgData->Width = 181;
				 // 
				 // groupBoxMsgRead
				 // 
				 this->groupBoxMsgRead->BackColor = System::Drawing::SystemColors::Control;
				 this->groupBoxMsgRead->Controls->Add(this->checkBoxMsgShowPeriod);
				 this->groupBoxMsgRead->Controls->Add(this->radioButtonMsgManual);
				 this->groupBoxMsgRead->Controls->Add(this->radioButtonMsgEvent);
				 this->groupBoxMsgRead->Controls->Add(this->listViewMsgs);
				 this->groupBoxMsgRead->Controls->Add(this->buttonMsgClear);
				 this->groupBoxMsgRead->Controls->Add(this->radioButtonMsgTimer);
				 this->groupBoxMsgRead->Controls->Add(this->buttonMsgRead);
				 this->groupBoxMsgRead->Dock = System::Windows::Forms::DockStyle::Fill;
				 this->groupBoxMsgRead->Location = System::Drawing::Point(0, 0);
				 this->groupBoxMsgRead->Name = L"groupBoxMsgRead";
				 this->groupBoxMsgRead->Size = System::Drawing::Size(876, 171);
				 this->groupBoxMsgRead->TabIndex = 0;
				 this->groupBoxMsgRead->TabStop = false;
				 this->groupBoxMsgRead->Text = L" Messages Reading ";
				 // 
				 // buttonMsgClear
				 // 
				 this->buttonMsgClear->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonMsgClear->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonMsgClear->Location = System::Drawing::Point(805, 66);
				 this->buttonMsgClear->Name = L"buttonMsgClear";
				 this->buttonMsgClear->Size = System::Drawing::Size(65, 23);
				 this->buttonMsgClear->TabIndex = 6;
				 this->buttonMsgClear->Text = L"Clear";
				 this->buttonMsgClear->UseVisualStyleBackColor = true;
				 this->buttonMsgClear->Click += gcnew System::EventHandler(this, &FormMain::buttonMsgClear_Click);
				 // 
				 // radioButtonMsgTimer
				 // 
				 this->radioButtonMsgTimer->AutoSize = true;
				 this->radioButtonMsgTimer->Checked = true;
				 this->radioButtonMsgTimer->Location = System::Drawing::Point(8, 14);
				 this->radioButtonMsgTimer->Name = L"radioButtonMsgTimer";
				 this->radioButtonMsgTimer->Size = System::Drawing::Size(117, 17);
				 this->radioButtonMsgTimer->TabIndex = 0;
				 this->radioButtonMsgTimer->TabStop = true;
				 this->radioButtonMsgTimer->Text = L"Read using a Timer";
				 this->radioButtonMsgTimer->UseVisualStyleBackColor = true;
				 this->radioButtonMsgTimer->CheckedChanged += gcnew System::EventHandler(this, &FormMain::radioButtonMsgRead_CheckedChanged);
				 // 
				 // buttonMsgRead
				 // 
				 this->buttonMsgRead->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonMsgRead->Enabled = false;
				 this->buttonMsgRead->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonMsgRead->Location = System::Drawing::Point(805, 37);
				 this->buttonMsgRead->Name = L"buttonMsgRead";
				 this->buttonMsgRead->Size = System::Drawing::Size(65, 23);
				 this->buttonMsgRead->TabIndex = 5;
				 this->buttonMsgRead->Text = L"Read";
				 this->buttonMsgRead->UseVisualStyleBackColor = true;
				 this->buttonMsgRead->Click += gcnew System::EventHandler(this, &FormMain::buttonMsgRead_Click);
				 // 
				 // tabPageMessages
				 // 
				 this->tabPageMessages->Controls->Add(this->groupBoxMsgRead);
				 this->tabPageMessages->Controls->Add(this->groupBoxMsgWrite);
				 this->tabPageMessages->Location = System::Drawing::Point(4, 22);
				 this->tabPageMessages->Name = L"tabPageMessages";
				 this->tabPageMessages->Size = System::Drawing::Size(876, 320);
				 this->tabPageMessages->TabIndex = 2;
				 this->tabPageMessages->Text = L"Messages";
				 this->tabPageMessages->UseVisualStyleBackColor = true;
				 // 
				 // groupBoxMsgWrite
				 // 
				 this->groupBoxMsgWrite->BackColor = System::Drawing::SystemColors::Control;
				 this->groupBoxMsgWrite->Controls->Add(this->numericUpDownPriority);
				 this->groupBoxMsgWrite->Controls->Add(this->checkBoxHasPriority);
				 this->groupBoxMsgWrite->Controls->Add(this->checkBoxBRS);
				 this->groupBoxMsgWrite->Controls->Add(this->checkBoxFDMessage);
				 this->groupBoxMsgWrite->Controls->Add(this->numericUpDownRemoteAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->numericUpDownTargetAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->numericUpDownSourceAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->buttonMsgDataFill);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgRemoteAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgTargetAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->textBoxMsgData);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgMapping);
				 this->groupBoxMsgWrite->Controls->Add(this->comboBoxMsgMapping);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgData);
				 this->groupBoxMsgWrite->Controls->Add(this->buttonMsgWrite);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgLength);
				 this->groupBoxMsgWrite->Controls->Add(this->labelMsgSourceAddr);
				 this->groupBoxMsgWrite->Controls->Add(this->numericUpDownMsgLength);
				 this->groupBoxMsgWrite->Dock = System::Windows::Forms::DockStyle::Bottom;
				 this->groupBoxMsgWrite->Location = System::Drawing::Point(0, 171);
				 this->groupBoxMsgWrite->Name = L"groupBoxMsgWrite";
				 this->groupBoxMsgWrite->Size = System::Drawing::Size(876, 149);
				 this->groupBoxMsgWrite->TabIndex = 1;
				 this->groupBoxMsgWrite->TabStop = false;
				 this->groupBoxMsgWrite->Text = L"Write Messages";
				 // 
				 // numericUpDownPriority
				 // 
				 this->numericUpDownPriority->Enabled = false;
				 this->numericUpDownPriority->Location = System::Drawing::Point(723, 53);
				 this->numericUpDownPriority->Name = L"numericUpDownPriority";
				 this->numericUpDownPriority->Size = System::Drawing::Size(77, 20);
				 this->numericUpDownPriority->TabIndex = 17;
				 this->numericUpDownPriority->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) { 6, 0, 0, 0 });
				 // 
				 // checkBoxHasPriority
				 // 
				 this->checkBoxHasPriority->AutoSize = true;
				 this->checkBoxHasPriority->Enabled = false;
				 this->checkBoxHasPriority->Location = System::Drawing::Point(722, 29);
				 this->checkBoxHasPriority->Name = L"checkBoxHasPriority";
				 this->checkBoxHasPriority->Size = System::Drawing::Size(78, 17);
				 this->checkBoxHasPriority->TabIndex = 16;
				 this->checkBoxHasPriority->Text = L"Has priority";
				 this->checkBoxHasPriority->UseVisualStyleBackColor = true;
				 this->checkBoxHasPriority->CheckedChanged += gcnew System::EventHandler(this, &FormMain::checkBoxHasPriority_CheckedChanged);
				 // 
				 // checkBoxBRS
				 // 
				 this->checkBoxBRS->AutoSize = true;
				 this->checkBoxBRS->Location = System::Drawing::Point(668, 53);
				 this->checkBoxBRS->Name = L"checkBoxBRS";
				 this->checkBoxBRS->Size = System::Drawing::Size(48, 17);
				 this->checkBoxBRS->TabIndex = 15;
				 this->checkBoxBRS->Text = L"BRS";
				 this->checkBoxBRS->UseVisualStyleBackColor = true;
				 // 
				 // checkBoxFDMessage
				 // 
				 this->checkBoxFDMessage->AutoSize = true;
				 this->checkBoxFDMessage->Location = System::Drawing::Point(668, 29);
				 this->checkBoxFDMessage->Name = L"checkBoxFDMessage";
				 this->checkBoxFDMessage->Size = System::Drawing::Size(40, 17);
				 this->checkBoxFDMessage->TabIndex = 14;
				 this->checkBoxFDMessage->Text = L"FD";
				 this->checkBoxFDMessage->UseVisualStyleBackColor = true;
				 this->checkBoxFDMessage->CheckedChanged += gcnew System::EventHandler(this, &FormMain::checkBoxFDMessage_CheckedChanged);
				 // 
				 // numericUpDownRemoteAddr
				 // 
				 this->numericUpDownRemoteAddr->BackColor = System::Drawing::Color::White;
				 this->numericUpDownRemoteAddr->Hexadecimal = true;
				 this->numericUpDownRemoteAddr->Location = System::Drawing::Point(413, 39);
				 this->numericUpDownRemoteAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
				 this->numericUpDownRemoteAddr->Name = L"numericUpDownRemoteAddr";
				 this->numericUpDownRemoteAddr->Size = System::Drawing::Size(65, 20);
				 this->numericUpDownRemoteAddr->TabIndex = 7;
				 // 
				 // numericUpDownTargetAddr
				 // 
				 this->numericUpDownTargetAddr->BackColor = System::Drawing::Color::White;
				 this->numericUpDownTargetAddr->Hexadecimal = true;
				 this->numericUpDownTargetAddr->Location = System::Drawing::Point(338, 39);
				 this->numericUpDownTargetAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
				 this->numericUpDownTargetAddr->Name = L"numericUpDownTargetAddr";
				 this->numericUpDownTargetAddr->Size = System::Drawing::Size(65, 20);
				 this->numericUpDownTargetAddr->TabIndex = 5;
				 // 
				 // numericUpDownSourceAddr
				 // 
				 this->numericUpDownSourceAddr->BackColor = System::Drawing::Color::White;
				 this->numericUpDownSourceAddr->Hexadecimal = true;
				 this->numericUpDownSourceAddr->Location = System::Drawing::Point(260, 39);
				 this->numericUpDownSourceAddr->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
				 this->numericUpDownSourceAddr->Name = L"numericUpDownSourceAddr";
				 this->numericUpDownSourceAddr->Size = System::Drawing::Size(65, 20);
				 this->numericUpDownSourceAddr->TabIndex = 3;
				 // 
				 // buttonMsgDataFill
				 // 
				 this->buttonMsgDataFill->Cursor = System::Windows::Forms::Cursors::Default;
				 this->buttonMsgDataFill->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonMsgDataFill->Location = System::Drawing::Point(565, 37);
				 this->buttonMsgDataFill->Name = L"buttonMsgDataFill";
				 this->buttonMsgDataFill->Size = System::Drawing::Size(65, 23);
				 this->buttonMsgDataFill->TabIndex = 10;
				 this->buttonMsgDataFill->Text = L"Fill";
				 this->buttonMsgDataFill->Click += gcnew System::EventHandler(this, &FormMain::buttonMsgDataFill_Click);
				 // 
				 // labelMsgRemoteAddr
				 // 
				 this->labelMsgRemoteAddr->AutoSize = true;
				 this->labelMsgRemoteAddr->Location = System::Drawing::Point(410, 21);
				 this->labelMsgRemoteAddr->Name = L"labelMsgRemoteAddr";
				 this->labelMsgRemoteAddr->Size = System::Drawing::Size(75, 13);
				 this->labelMsgRemoteAddr->TabIndex = 6;
				 this->labelMsgRemoteAddr->Text = L"Remote (Hex):";
				 // 
				 // labelMsgTargetAddr
				 // 
				 this->labelMsgTargetAddr->AutoSize = true;
				 this->labelMsgTargetAddr->Location = System::Drawing::Point(335, 21);
				 this->labelMsgTargetAddr->Name = L"labelMsgTargetAddr";
				 this->labelMsgTargetAddr->Size = System::Drawing::Size(69, 13);
				 this->labelMsgTargetAddr->TabIndex = 4;
				 this->labelMsgTargetAddr->Text = L"Target (Hex):";
				 // 
				 // textBoxMsgData
				 // 
				 this->textBoxMsgData->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
					 | System::Windows::Forms::AnchorStyles::Left)
					 | System::Windows::Forms::AnchorStyles::Right));
				 this->textBoxMsgData->Location = System::Drawing::Point(9, 82);
				 this->textBoxMsgData->MaxLength = 4095;
				 this->textBoxMsgData->Multiline = true;
				 this->textBoxMsgData->Name = L"textBoxMsgData";
				 this->textBoxMsgData->ScrollBars = System::Windows::Forms::ScrollBars::Vertical;
				 this->textBoxMsgData->Size = System::Drawing::Size(790, 61);
				 this->textBoxMsgData->TabIndex = 12;
				 this->textBoxMsgData->KeyPress += gcnew System::Windows::Forms::KeyPressEventHandler(this, &FormMain::textBoxHexOnly_KeyPress);
				 this->textBoxMsgData->Leave += gcnew System::EventHandler(this, &FormMain::numericUpDownMsgLength_ValueChanged);
				 // 
				 // labelMsgMapping
				 // 
				 this->labelMsgMapping->AutoSize = true;
				 this->labelMsgMapping->Location = System::Drawing::Point(6, 21);
				 this->labelMsgMapping->Name = L"labelMsgMapping";
				 this->labelMsgMapping->Size = System::Drawing::Size(51, 13);
				 this->labelMsgMapping->TabIndex = 0;
				 this->labelMsgMapping->Text = L"Mapping:";
				 // 
				 // comboBoxMsgMapping
				 // 
				 this->comboBoxMsgMapping->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxMsgMapping->FormattingEnabled = true;
				 this->comboBoxMsgMapping->Location = System::Drawing::Point(9, 37);
				 this->comboBoxMsgMapping->Name = L"comboBoxMsgMapping";
				 this->comboBoxMsgMapping->Size = System::Drawing::Size(236, 21);
				 this->comboBoxMsgMapping->TabIndex = 1;
				 this->comboBoxMsgMapping->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMain::comboBoxMsgMapping_SelectedIndexChanged);
				 // 
				 // labelMsgData
				 // 
				 this->labelMsgData->AutoSize = true;
				 this->labelMsgData->Location = System::Drawing::Point(6, 66);
				 this->labelMsgData->Name = L"labelMsgData";
				 this->labelMsgData->Size = System::Drawing::Size(61, 13);
				 this->labelMsgData->TabIndex = 11;
				 this->labelMsgData->Text = L"Data (Hex):";
				 // 
				 // buttonMsgWrite
				 // 
				 this->buttonMsgWrite->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonMsgWrite->Cursor = System::Windows::Forms::Cursors::Default;
				 this->buttonMsgWrite->Enabled = false;
				 this->buttonMsgWrite->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonMsgWrite->Location = System::Drawing::Point(805, 80);
				 this->buttonMsgWrite->Name = L"buttonMsgWrite";
				 this->buttonMsgWrite->Size = System::Drawing::Size(65, 23);
				 this->buttonMsgWrite->TabIndex = 13;
				 this->buttonMsgWrite->Text = L"Write";
				 this->buttonMsgWrite->Click += gcnew System::EventHandler(this, &FormMain::buttonMsgWrite_Click);
				 // 
				 // labelMsgLength
				 // 
				 this->labelMsgLength->AutoSize = true;
				 this->labelMsgLength->Location = System::Drawing::Point(491, 21);
				 this->labelMsgLength->Name = L"labelMsgLength";
				 this->labelMsgLength->Size = System::Drawing::Size(43, 13);
				 this->labelMsgLength->TabIndex = 8;
				 this->labelMsgLength->Text = L"Length:";
				 // 
				 // labelMsgSourceAddr
				 // 
				 this->labelMsgSourceAddr->AutoSize = true;
				 this->labelMsgSourceAddr->Location = System::Drawing::Point(257, 21);
				 this->labelMsgSourceAddr->Name = L"labelMsgSourceAddr";
				 this->labelMsgSourceAddr->Size = System::Drawing::Size(72, 13);
				 this->labelMsgSourceAddr->TabIndex = 2;
				 this->labelMsgSourceAddr->Text = L"Source (Hex):";
				 // 
				 // numericUpDownMsgLength
				 // 
				 this->numericUpDownMsgLength->BackColor = System::Drawing::Color::White;
				 this->numericUpDownMsgLength->Location = System::Drawing::Point(494, 39);
				 this->numericUpDownMsgLength->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 4095, 0, 0, 0 });
				 this->numericUpDownMsgLength->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 1, 0, 0, 0 });
				 this->numericUpDownMsgLength->Name = L"numericUpDownMsgLength";
				 this->numericUpDownMsgLength->Size = System::Drawing::Size(65, 20);
				 this->numericUpDownMsgLength->TabIndex = 9;
				 this->numericUpDownMsgLength->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) { 8, 0, 0, 0 });
				 this->numericUpDownMsgLength->ValueChanged += gcnew System::EventHandler(this, &FormMain::numericUpDownMsgLength_ValueChanged);
				 // 
				 // columnHeaderMappingRemoteAddr
				 // 
				 this->columnHeaderMappingRemoteAddr->Text = L"RA";
				 this->columnHeaderMappingRemoteAddr->Width = 50;
				 // 
				 // columnHeaderMappingFormat
				 // 
				 this->columnHeaderMappingFormat->Text = L"Format";
				 this->columnHeaderMappingFormat->Width = 100;
				 // 
				 // columnHeaderMappingTargetAddr
				 // 
				 this->columnHeaderMappingTargetAddr->Text = L"TA";
				 this->columnHeaderMappingTargetAddr->Width = 50;
				 // 
				 // timerRead
				 // 
				 this->timerRead->Interval = 50;
				 this->timerRead->Tick += gcnew System::EventHandler(this, &FormMain::timerRead_Tick);
				 // 
				 // columnHeaderMappingSourceAddr
				 // 
				 this->columnHeaderMappingSourceAddr->Text = L"SA";
				 this->columnHeaderMappingSourceAddr->Width = 50;
				 // 
				 // buttonParamVersion
				 // 
				 this->buttonParamVersion->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamVersion->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamVersion->Location = System::Drawing::Point(731, 19);
				 this->buttonParamVersion->Name = L"buttonParamVersion";
				 this->buttonParamVersion->Size = System::Drawing::Size(65, 23);
				 this->buttonParamVersion->TabIndex = 12;
				 this->buttonParamVersion->Text = L"Version";
				 this->buttonParamVersion->UseVisualStyleBackColor = true;
				 this->buttonParamVersion->Click += gcnew System::EventHandler(this, &FormMain::buttonParamVersion_Click);
				 // 
				 // comboBoxHwType
				 // 
				 this->comboBoxHwType->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxHwType->Items->AddRange(gcnew cli::array< System::Object^  >(7) {
					 L"ISA-82C200", L"ISA-SJA1000", L"ISA-PHYTEC",
						 L"DNG-82C200", L"DNG-82C200 EPP", L"DNG-SJA1000", L"DNG-SJA1000 EPP"
				 });
				 this->comboBoxHwType->Location = System::Drawing::Point(326, 32);
				 this->comboBoxHwType->Name = L"comboBoxHwType";
				 this->comboBoxHwType->Size = System::Drawing::Size(120, 21);
				 this->comboBoxHwType->TabIndex = 50;
				 // 
				 // comboBoxInterrupt
				 // 
				 this->comboBoxInterrupt->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxInterrupt->Items->AddRange(gcnew cli::array< System::Object^  >(9) {
					 L"3", L"4", L"5", L"7", L"9", L"10", L"11",
						 L"12", L"15"
				 });
				 this->comboBoxInterrupt->Location = System::Drawing::Point(513, 32);
				 this->comboBoxInterrupt->Name = L"comboBoxInterrupt";
				 this->comboBoxInterrupt->Size = System::Drawing::Size(55, 21);
				 this->comboBoxInterrupt->TabIndex = 52;
				 // 
				 // labelConnInterrupt
				 // 
				 this->labelConnInterrupt->Location = System::Drawing::Point(515, 15);
				 this->labelConnInterrupt->Name = L"labelConnInterrupt";
				 this->labelConnInterrupt->Size = System::Drawing::Size(53, 23);
				 this->labelConnInterrupt->TabIndex = 56;
				 this->labelConnInterrupt->Text = L"Interrupt:";
				 // 
				 // comboBoxIoPort
				 // 
				 this->comboBoxIoPort->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxIoPort->Items->AddRange(gcnew cli::array< System::Object^  >(24) {
					 L"0100", L"0120", L"0140", L"0200", L"0220",
						 L"0240", L"0260", L"0278", L"0280", L"02A0", L"02C0", L"02E0", L"02E8", L"02F8", L"0300", L"0320", L"0340", L"0360", L"0378",
						 L"0380", L"03BC", L"03E0", L"03E8", L"03F8"
				 });
				 this->comboBoxIoPort->Location = System::Drawing::Point(452, 32);
				 this->comboBoxIoPort->Name = L"comboBoxIoPort";
				 this->comboBoxIoPort->Size = System::Drawing::Size(55, 21);
				 this->comboBoxIoPort->TabIndex = 51;
				 // 
				 // labelConnIoPort
				 // 
				 this->labelConnIoPort->Location = System::Drawing::Point(452, 15);
				 this->labelConnIoPort->Name = L"labelConnIoPort";
				 this->labelConnIoPort->Size = System::Drawing::Size(55, 23);
				 this->labelConnIoPort->TabIndex = 55;
				 this->labelConnIoPort->Text = L"I/O Port:";
				 // 
				 // labelConnHwType
				 // 
				 this->labelConnHwType->Location = System::Drawing::Point(327, 15);
				 this->labelConnHwType->Name = L"labelConnHwType";
				 this->labelConnHwType->Size = System::Drawing::Size(90, 23);
				 this->labelConnHwType->TabIndex = 54;
				 this->labelConnHwType->Text = L"Hardware Type:";
				 // 
				 // comboBoxBaudrate
				 // 
				 this->comboBoxBaudrate->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxBaudrate->Items->AddRange(gcnew cli::array< System::Object^  >(14) {
					 L"1 MBit/sec", L"10 kBit/sec", L"100 kBit/sec",
						 L"125 kBit/sec", L"20 kBit/sec", L"250 kBit/sec", L"33,333 kBit/s", L"47,619 kBit/s", L"5 kBit/sec", L"50 kBit/sec", L"500 kBit/sec",
						 L"800 kBit/s", L"83,333 kBit/s", L"95,238 kBit/s"
				 });
				 this->comboBoxBaudrate->Location = System::Drawing::Point(204, 32);
				 this->comboBoxBaudrate->Name = L"comboBoxBaudrate";
				 this->comboBoxBaudrate->Size = System::Drawing::Size(116, 21);
				 this->comboBoxBaudrate->TabIndex = 49;
				 // 
				 // buttonParamReset
				 // 
				 this->buttonParamReset->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamReset->Enabled = false;
				 this->buttonParamReset->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamReset->Location = System::Drawing::Point(802, 48);
				 this->buttonParamReset->Name = L"buttonParamReset";
				 this->buttonParamReset->Size = System::Drawing::Size(65, 23);
				 this->buttonParamReset->TabIndex = 15;
				 this->buttonParamReset->Text = L"Reset";
				 this->buttonParamReset->UseVisualStyleBackColor = true;
				 this->buttonParamReset->Click += gcnew System::EventHandler(this, &FormMain::buttonParamReset_Click);
				 // 
				 // groupBoxParamInfo
				 // 
				 this->groupBoxParamInfo->BackColor = System::Drawing::SystemColors::Control;
				 this->groupBoxParamInfo->Controls->Add(this->buttonParamReset);
				 this->groupBoxParamInfo->Controls->Add(this->buttonParamStatus);
				 this->groupBoxParamInfo->Controls->Add(this->buttonParamVersion);
				 this->groupBoxParamInfo->Controls->Add(this->listBoxParamInfo);
				 this->groupBoxParamInfo->Controls->Add(this->buttonParamInfoClear);
				 this->groupBoxParamInfo->Dock = System::Windows::Forms::DockStyle::Fill;
				 this->groupBoxParamInfo->Location = System::Drawing::Point(3, 61);
				 this->groupBoxParamInfo->Name = L"groupBoxParamInfo";
				 this->groupBoxParamInfo->Size = System::Drawing::Size(870, 256);
				 this->groupBoxParamInfo->TabIndex = 10;
				 this->groupBoxParamInfo->TabStop = false;
				 this->groupBoxParamInfo->Text = L"Information";
				 // 
				 // buttonParamStatus
				 // 
				 this->buttonParamStatus->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamStatus->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamStatus->Location = System::Drawing::Point(731, 48);
				 this->buttonParamStatus->Name = L"buttonParamStatus";
				 this->buttonParamStatus->Size = System::Drawing::Size(65, 23);
				 this->buttonParamStatus->TabIndex = 14;
				 this->buttonParamStatus->Text = L"Status";
				 this->buttonParamStatus->UseVisualStyleBackColor = true;
				 this->buttonParamStatus->Click += gcnew System::EventHandler(this, &FormMain::buttonParamStatus_Click);
				 // 
				 // listBoxParamInfo
				 // 
				 this->listBoxParamInfo->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
					 | System::Windows::Forms::AnchorStyles::Left)
					 | System::Windows::Forms::AnchorStyles::Right));
				 this->listBoxParamInfo->FormattingEnabled = true;
				 this->listBoxParamInfo->Items->AddRange(gcnew cli::array< System::Object^  >(6) {
					 L"Select a Hardware and a configuration for it. Then click \"Initialize\" button",
						 L"When activated, configure ISO-TP mappings in order to transmit and receive ISO-TP"
						 L" messages.", L"---", L"Note that to successfully transmit ISO-TP messages, you need a valid ISO-TP node "
						 L"to communicate with.",
						 L"You can run a second instance of this application on another channel to do so.", L"---"
				 });
				 this->listBoxParamInfo->Location = System::Drawing::Point(6, 19);
				 this->listBoxParamInfo->Name = L"listBoxParamInfo";
				 this->listBoxParamInfo->ScrollAlwaysVisible = true;
				 this->listBoxParamInfo->Size = System::Drawing::Size(716, 225);
				 this->listBoxParamInfo->TabIndex = 11;
				 // 
				 // buttonParamInfoClear
				 // 
				 this->buttonParamInfoClear->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamInfoClear->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamInfoClear->Location = System::Drawing::Point(802, 19);
				 this->buttonParamInfoClear->Name = L"buttonParamInfoClear";
				 this->buttonParamInfoClear->Size = System::Drawing::Size(65, 23);
				 this->buttonParamInfoClear->TabIndex = 13;
				 this->buttonParamInfoClear->Text = L"Clear";
				 this->buttonParamInfoClear->UseVisualStyleBackColor = true;
				 this->buttonParamInfoClear->Click += gcnew System::EventHandler(this, &FormMain::buttonParamInfoClear_Click);
				 // 
				 // tabPageParameters
				 // 
				 this->tabPageParameters->Controls->Add(this->groupBoxParamInfo);
				 this->tabPageParameters->Controls->Add(this->groupBoxParamCfg);
				 this->tabPageParameters->Location = System::Drawing::Point(4, 22);
				 this->tabPageParameters->Name = L"tabPageParameters";
				 this->tabPageParameters->Padding = System::Windows::Forms::Padding(3);
				 this->tabPageParameters->Size = System::Drawing::Size(876, 320);
				 this->tabPageParameters->TabIndex = 3;
				 this->tabPageParameters->Text = L"Parameters";
				 this->tabPageParameters->UseVisualStyleBackColor = true;
				 // 
				 // groupBoxParamCfg
				 // 
				 this->groupBoxParamCfg->BackColor = System::Drawing::SystemColors::Control;
				 this->groupBoxParamCfg->Controls->Add(this->labelParameter);
				 this->groupBoxParamCfg->Controls->Add(this->comboBoxParameter);
				 this->groupBoxParamCfg->Controls->Add(this->labelParamActivation);
				 this->groupBoxParamCfg->Controls->Add(this->radioButtonParamActive);
				 this->groupBoxParamCfg->Controls->Add(this->radioButtonParamInactive);
				 this->groupBoxParamCfg->Controls->Add(this->labelParamValue);
				 this->groupBoxParamCfg->Controls->Add(this->numericUpDownParamValue);
				 this->groupBoxParamCfg->Controls->Add(this->buttonParamGet);
				 this->groupBoxParamCfg->Controls->Add(this->buttonParamSet);
				 this->groupBoxParamCfg->Dock = System::Windows::Forms::DockStyle::Top;
				 this->groupBoxParamCfg->Location = System::Drawing::Point(3, 3);
				 this->groupBoxParamCfg->Name = L"groupBoxParamCfg";
				 this->groupBoxParamCfg->Size = System::Drawing::Size(870, 58);
				 this->groupBoxParamCfg->TabIndex = 0;
				 this->groupBoxParamCfg->TabStop = false;
				 this->groupBoxParamCfg->Text = L" Configuration Parameters ";
				 // 
				 // labelParameter
				 // 
				 this->labelParameter->AutoSize = true;
				 this->labelParameter->Location = System::Drawing::Point(6, 16);
				 this->labelParameter->Name = L"labelParameter";
				 this->labelParameter->Size = System::Drawing::Size(58, 13);
				 this->labelParameter->TabIndex = 1;
				 this->labelParameter->Text = L"Parameter:";
				 // 
				 // comboBoxParameter
				 // 
				 this->comboBoxParameter->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxParameter->FormattingEnabled = true;
				 this->comboBoxParameter->Location = System::Drawing::Point(6, 31);
				 this->comboBoxParameter->Name = L"comboBoxParameter";
				 this->comboBoxParameter->Size = System::Drawing::Size(221, 21);
				 this->comboBoxParameter->TabIndex = 2;
				 this->comboBoxParameter->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMain::comboBoxParameter_SelectedIndexChanged);
				 // 
				 // labelParamActivation
				 // 
				 this->labelParamActivation->AutoSize = true;
				 this->labelParamActivation->Location = System::Drawing::Point(241, 11);
				 this->labelParamActivation->Name = L"labelParamActivation";
				 this->labelParamActivation->Size = System::Drawing::Size(57, 13);
				 this->labelParamActivation->TabIndex = 3;
				 this->labelParamActivation->Text = L"Activation:";
				 // 
				 // radioButtonParamActive
				 // 
				 this->radioButtonParamActive->Checked = true;
				 this->radioButtonParamActive->Location = System::Drawing::Point(238, 32);
				 this->radioButtonParamActive->Name = L"radioButtonParamActive";
				 this->radioButtonParamActive->Size = System::Drawing::Size(56, 17);
				 this->radioButtonParamActive->TabIndex = 4;
				 this->radioButtonParamActive->TabStop = true;
				 this->radioButtonParamActive->Text = L"Active";
				 this->radioButtonParamActive->UseVisualStyleBackColor = true;
				 // 
				 // radioButtonParamInactive
				 // 
				 this->radioButtonParamInactive->Location = System::Drawing::Point(300, 32);
				 this->radioButtonParamInactive->Name = L"radioButtonParamInactive";
				 this->radioButtonParamInactive->Size = System::Drawing::Size(67, 17);
				 this->radioButtonParamInactive->TabIndex = 5;
				 this->radioButtonParamInactive->Text = L"Inactive";
				 this->radioButtonParamInactive->UseVisualStyleBackColor = true;
				 // 
				 // labelParamValue
				 // 
				 this->labelParamValue->AutoSize = true;
				 this->labelParamValue->Location = System::Drawing::Point(405, 12);
				 this->labelParamValue->Name = L"labelParamValue";
				 this->labelParamValue->Size = System::Drawing::Size(87, 13);
				 this->labelParamValue->TabIndex = 6;
				 this->labelParamValue->Text = L"Parameter value:";
				 // 
				 // numericUpDownParamValue
				 // 
				 this->numericUpDownParamValue->Enabled = false;
				 this->numericUpDownParamValue->Hexadecimal = true;
				 this->numericUpDownParamValue->Location = System::Drawing::Point(408, 29);
				 this->numericUpDownParamValue->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 255, 0, 0, 0 });
				 this->numericUpDownParamValue->Name = L"numericUpDownParamValue";
				 this->numericUpDownParamValue->Size = System::Drawing::Size(99, 20);
				 this->numericUpDownParamValue->TabIndex = 7;
				 // 
				 // buttonParamGet
				 // 
				 this->buttonParamGet->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamGet->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamGet->Location = System::Drawing::Point(802, 26);
				 this->buttonParamGet->Name = L"buttonParamGet";
				 this->buttonParamGet->Size = System::Drawing::Size(65, 23);
				 this->buttonParamGet->TabIndex = 9;
				 this->buttonParamGet->Text = L"Get";
				 this->buttonParamGet->UseVisualStyleBackColor = true;
				 this->buttonParamGet->Click += gcnew System::EventHandler(this, &FormMain::buttonParamGet_Click);
				 // 
				 // buttonParamSet
				 // 
				 this->buttonParamSet->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonParamSet->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonParamSet->Location = System::Drawing::Point(731, 26);
				 this->buttonParamSet->Name = L"buttonParamSet";
				 this->buttonParamSet->Size = System::Drawing::Size(65, 23);
				 this->buttonParamSet->TabIndex = 8;
				 this->buttonParamSet->Text = L"Set";
				 this->buttonParamSet->UseVisualStyleBackColor = true;
				 this->buttonParamSet->Click += gcnew System::EventHandler(this, &FormMain::buttonParamSet_Click);
				 // 
				 // tabControlMain
				 // 
				 this->tabControlMain->Controls->Add(this->tabPageParameters);
				 this->tabControlMain->Controls->Add(this->tabPageMappings);
				 this->tabControlMain->Controls->Add(this->tabPageMessages);
				 this->tabControlMain->Dock = System::Windows::Forms::DockStyle::Fill;
				 this->tabControlMain->Location = System::Drawing::Point(0, 65);
				 this->tabControlMain->Name = L"tabControlMain";
				 this->tabControlMain->SelectedIndex = 0;
				 this->tabControlMain->Size = System::Drawing::Size(884, 346);
				 this->tabControlMain->TabIndex = 46;
				 // 
				 // tabPageMappings
				 // 
				 this->tabPageMappings->BackColor = System::Drawing::SystemColors::Control;
				 this->tabPageMappings->Controls->Add(this->buttonMappingLoad);
				 this->tabPageMappings->Controls->Add(this->buttonMappingSave);
				 this->tabPageMappings->Controls->Add(this->buttonMappingSample);
				 this->tabPageMappings->Controls->Add(this->buttonMappingDel);
				 this->tabPageMappings->Controls->Add(this->buttonMappingAdd);
				 this->tabPageMappings->Controls->Add(this->listViewMappings);
				 this->tabPageMappings->Location = System::Drawing::Point(4, 22);
				 this->tabPageMappings->Name = L"tabPageMappings";
				 this->tabPageMappings->Padding = System::Windows::Forms::Padding(3);
				 this->tabPageMappings->Size = System::Drawing::Size(876, 320);
				 this->tabPageMappings->TabIndex = 0;
				 this->tabPageMappings->Text = L"Mappings";
				 // 
				 // buttonMappingLoad
				 // 
				 this->buttonMappingLoad->Location = System::Drawing::Point(571, 291);
				 this->buttonMappingLoad->Name = L"buttonMappingLoad";
				 this->buttonMappingLoad->Size = System::Drawing::Size(91, 23);
				 this->buttonMappingLoad->TabIndex = 5;
				 this->buttonMappingLoad->Text = L"Load Mappings";
				 this->buttonMappingLoad->UseVisualStyleBackColor = true;
				 this->buttonMappingLoad->Click += gcnew System::EventHandler(this, &FormMain::buttonMappingLoad_Click);
				 // 
				 // buttonMappingSave
				 // 
				 this->buttonMappingSave->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonMappingSave->Location = System::Drawing::Point(668, 291);
				 this->buttonMappingSave->Name = L"buttonMappingSave";
				 this->buttonMappingSave->Size = System::Drawing::Size(91, 23);
				 this->buttonMappingSave->TabIndex = 4;
				 this->buttonMappingSave->Text = L"Save Mappings";
				 this->buttonMappingSave->UseVisualStyleBackColor = true;
				 this->buttonMappingSave->Click += gcnew System::EventHandler(this, &FormMain::buttonMappingSave_Click);
				 // 
				 // buttonMappingSample
				 // 
				 this->buttonMappingSample->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonMappingSample->Location = System::Drawing::Point(773, 291);
				 this->buttonMappingSample->Name = L"buttonMappingSample";
				 this->buttonMappingSample->Size = System::Drawing::Size(75, 23);
				 this->buttonMappingSample->TabIndex = 3;
				 this->buttonMappingSample->Text = L"Fill example";
				 this->buttonMappingSample->UseVisualStyleBackColor = true;
				 this->buttonMappingSample->Click += gcnew System::EventHandler(this, &FormMain::buttonMappingSample_Click);
				 // 
				 // buttonMappingDel
				 // 
				 this->buttonMappingDel->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left));
				 this->buttonMappingDel->Location = System::Drawing::Point(87, 291);
				 this->buttonMappingDel->Name = L"buttonMappingDel";
				 this->buttonMappingDel->Size = System::Drawing::Size(75, 23);
				 this->buttonMappingDel->TabIndex = 2;
				 this->buttonMappingDel->Text = L"Remove";
				 this->buttonMappingDel->UseVisualStyleBackColor = true;
				 this->buttonMappingDel->Click += gcnew System::EventHandler(this, &FormMain::buttonMappingDel_Click);
				 // 
				 // buttonMappingAdd
				 // 
				 this->buttonMappingAdd->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left));
				 this->buttonMappingAdd->Location = System::Drawing::Point(6, 291);
				 this->buttonMappingAdd->Name = L"buttonMappingAdd";
				 this->buttonMappingAdd->Size = System::Drawing::Size(75, 23);
				 this->buttonMappingAdd->TabIndex = 1;
				 this->buttonMappingAdd->Text = L"Add";
				 this->buttonMappingAdd->UseVisualStyleBackColor = true;
				 this->buttonMappingAdd->Click += gcnew System::EventHandler(this, &FormMain::buttonMappingAdd_Click);
				 // 
				 // listViewMappings
				 // 
				 this->listViewMappings->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
					 | System::Windows::Forms::AnchorStyles::Left)
					 | System::Windows::Forms::AnchorStyles::Right));
				 this->listViewMappings->Columns->AddRange(gcnew cli::array< System::Windows::Forms::ColumnHeader^  >(9) {
					 this->columnHeaderMappingCanId,
						 this->columnHeaderMappingCanIdResponse, this->columnHeaderMappingTargetType, this->columnHeaderMappingCanIdType, this->columnHeaderMappingSourceAddr,
						 this->columnHeaderMappingTargetAddr, this->columnHeaderMappingMsgType, this->columnHeaderMappingFormat, this->columnHeaderMappingRemoteAddr
				 });
				 this->listViewMappings->FullRowSelect = true;
				 this->listViewMappings->Location = System::Drawing::Point(6, 6);
				 this->listViewMappings->Name = L"listViewMappings";
				 this->listViewMappings->Size = System::Drawing::Size(842, 279);
				 this->listViewMappings->TabIndex = 0;
				 this->listViewMappings->UseCompatibleStateImageBehavior = false;
				 this->listViewMappings->View = System::Windows::Forms::View::Details;
				 this->listViewMappings->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMain::listViewMappings_SelectedIndexChanged);
				 // 
				 // columnHeaderMappingCanId
				 // 
				 this->columnHeaderMappingCanId->Text = L"CAN ID";
				 this->columnHeaderMappingCanId->Width = 100;
				 // 
				 // columnHeaderMappingCanIdResponse
				 // 
				 this->columnHeaderMappingCanIdResponse->Text = L"CAN ID Response";
				 this->columnHeaderMappingCanIdResponse->Width = 100;
				 // 
				 // columnHeaderMappingTargetType
				 // 
				 this->columnHeaderMappingTargetType->Text = L"Target Type";
				 this->columnHeaderMappingTargetType->Width = 70;
				 // 
				 // columnHeaderMappingCanIdType
				 // 
				 this->columnHeaderMappingCanIdType->Text = L"ID type";
				 this->columnHeaderMappingCanIdType->Width = 50;
				 // 
				 // buttonHwRefresh
				 // 
				 this->buttonHwRefresh->Cursor = System::Windows::Forms::Cursors::Default;
				 this->buttonHwRefresh->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonHwRefresh->Location = System::Drawing::Point(141, 31);
				 this->buttonHwRefresh->Name = L"buttonHwRefresh";
				 this->buttonHwRefresh->Size = System::Drawing::Size(57, 23);
				 this->buttonHwRefresh->TabIndex = 45;
				 this->buttonHwRefresh->Text = L"Refresh";
				 this->buttonHwRefresh->Click += gcnew System::EventHandler(this, &FormMain::buttonHwRefresh_Click);
				 // 
				 // comboBoxChannel
				 // 
				 this->comboBoxChannel->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
				 this->comboBoxChannel->Font = (gcnew System::Drawing::Font(L"Consolas", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->comboBoxChannel->Location = System::Drawing::Point(8, 32);
				 this->comboBoxChannel->Name = L"comboBoxChannel";
				 this->comboBoxChannel->Size = System::Drawing::Size(127, 21);
				 this->comboBoxChannel->TabIndex = 32;
				 this->comboBoxChannel->SelectedIndexChanged += gcnew System::EventHandler(this, &FormMain::comboBoxChannel_SelectedIndexChanged);
				 // 
				 // labelConnHardware
				 // 
				 this->labelConnHardware->Location = System::Drawing::Point(7, 16);
				 this->labelConnHardware->Name = L"labelConnHardware";
				 this->labelConnHardware->Size = System::Drawing::Size(56, 23);
				 this->labelConnHardware->TabIndex = 40;
				 this->labelConnHardware->Text = L"Hardware:";
				 // 
				 // buttonInit
				 // 
				 this->buttonInit->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonInit->Cursor = System::Windows::Forms::Cursors::Default;
				 this->buttonInit->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonInit->Location = System::Drawing::Point(738, 30);
				 this->buttonInit->Name = L"buttonInit";
				 this->buttonInit->Size = System::Drawing::Size(65, 23);
				 this->buttonInit->TabIndex = 34;
				 this->buttonInit->Text = L"Initialize";
				 this->buttonInit->Click += gcnew System::EventHandler(this, &FormMain::buttonInit_Click);
				 // 
				 // buttonRelease
				 // 
				 this->buttonRelease->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right));
				 this->buttonRelease->Cursor = System::Windows::Forms::Cursors::Default;
				 this->buttonRelease->Enabled = false;
				 this->buttonRelease->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->buttonRelease->Location = System::Drawing::Point(809, 30);
				 this->buttonRelease->Name = L"buttonRelease";
				 this->buttonRelease->Size = System::Drawing::Size(65, 23);
				 this->buttonRelease->TabIndex = 35;
				 this->buttonRelease->Text = L"Release";
				 this->buttonRelease->Click += gcnew System::EventHandler(this, &FormMain::buttonRelease_Click);
				 // 
				 // groupBoxConnection
				 // 
				 this->groupBoxConnection->Controls->Add(this->checkBoxCanFd);
				 this->groupBoxConnection->Controls->Add(this->comboBoxHwType);
				 this->groupBoxConnection->Controls->Add(this->comboBoxInterrupt);
				 this->groupBoxConnection->Controls->Add(this->labelConnInterrupt);
				 this->groupBoxConnection->Controls->Add(this->comboBoxIoPort);
				 this->groupBoxConnection->Controls->Add(this->labelConnIoPort);
				 this->groupBoxConnection->Controls->Add(this->labelConnHwType);
				 this->groupBoxConnection->Controls->Add(this->comboBoxBaudrate);
				 this->groupBoxConnection->Controls->Add(this->buttonHwRefresh);
				 this->groupBoxConnection->Controls->Add(this->comboBoxChannel);
				 this->groupBoxConnection->Controls->Add(this->labelConnHardware);
				 this->groupBoxConnection->Controls->Add(this->buttonInit);
				 this->groupBoxConnection->Controls->Add(this->buttonRelease);
				 this->groupBoxConnection->Controls->Add(this->labelConnBaudrate);
				 this->groupBoxConnection->Controls->Add(this->labelConnBitRate);
				 this->groupBoxConnection->Controls->Add(this->textBoxCanFdBitrate);
				 this->groupBoxConnection->Dock = System::Windows::Forms::DockStyle::Top;
				 this->groupBoxConnection->FlatStyle = System::Windows::Forms::FlatStyle::System;
				 this->groupBoxConnection->Location = System::Drawing::Point(0, 0);
				 this->groupBoxConnection->Name = L"groupBoxConnection";
				 this->groupBoxConnection->Size = System::Drawing::Size(884, 65);
				 this->groupBoxConnection->TabIndex = 45;
				 this->groupBoxConnection->TabStop = false;
				 this->groupBoxConnection->Text = L" Connection ";
				 // 
				 // checkBoxCanFd
				 // 
				 this->checkBoxCanFd->AutoSize = true;
				 this->checkBoxCanFd->Location = System::Drawing::Point(672, 32);
				 this->checkBoxCanFd->Name = L"checkBoxCanFd";
				 this->checkBoxCanFd->Size = System::Drawing::Size(65, 17);
				 this->checkBoxCanFd->TabIndex = 59;
				 this->checkBoxCanFd->Text = L"CAN-FD";
				 this->checkBoxCanFd->UseVisualStyleBackColor = true;
				 this->checkBoxCanFd->CheckedChanged += gcnew System::EventHandler(this, &FormMain::checkBoxCanFd_CheckedChanged);
				 // 
				 // labelConnBaudrate
				 // 
				 this->labelConnBaudrate->Location = System::Drawing::Point(204, 15);
				 this->labelConnBaudrate->Name = L"labelConnBaudrate";
				 this->labelConnBaudrate->Size = System::Drawing::Size(56, 23);
				 this->labelConnBaudrate->TabIndex = 53;
				 this->labelConnBaudrate->Text = L"Baudrate:";
				 // 
				 // labelConnBitRate
				 // 
				 this->labelConnBitRate->AutoSize = true;
				 this->labelConnBitRate->Location = System::Drawing::Point(204, 15);
				 this->labelConnBitRate->Name = L"labelConnBitRate";
				 this->labelConnBitRate->Size = System::Drawing::Size(43, 13);
				 this->labelConnBitRate->TabIndex = 57;
				 this->labelConnBitRate->Text = L"Bit rate:";
				 this->labelConnBitRate->Visible = false;
				 // 
				 // textBoxCanFdBitrate
				 // 
				 this->textBoxCanFdBitrate->Location = System::Drawing::Point(204, 28);
				 this->textBoxCanFdBitrate->Multiline = true;
				 this->textBoxCanFdBitrate->Name = L"textBoxCanFdBitrate";
				 this->textBoxCanFdBitrate->Size = System::Drawing::Size(461, 32);
				 this->textBoxCanFdBitrate->TabIndex = 58;
				 this->textBoxCanFdBitrate->Visible = false;
				 // 
				 // timerDisplay
				 // 
				 this->timerDisplay->Tick += gcnew System::EventHandler(this, &FormMain::timerDisplay_Tick);
				 // 
				 // FormMain
				 // 
				 this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
				 this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
				 this->ClientSize = System::Drawing::Size(884, 411);
				 this->Controls->Add(this->tabControlMain);
				 this->Controls->Add(this->groupBoxConnection);
				 this->Name = L"FormMain";
				 this->Text = L"PCAN ISO-TP Example";
				 this->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &FormMain::FormMain_FormClosed);
				 this->Shown += gcnew System::EventHandler(this, &FormMain::FormMain_Shown);
				 this->groupBoxMsgRead->ResumeLayout(false);
				 this->groupBoxMsgRead->PerformLayout();
				 this->tabPageMessages->ResumeLayout(false);
				 this->groupBoxMsgWrite->ResumeLayout(false);
				 this->groupBoxMsgWrite->PerformLayout();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownPriority))->EndInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownRemoteAddr))->EndInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownTargetAddr))->EndInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownSourceAddr))->EndInit();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownMsgLength))->EndInit();
				 this->groupBoxParamInfo->ResumeLayout(false);
				 this->tabPageParameters->ResumeLayout(false);
				 this->groupBoxParamCfg->ResumeLayout(false);
				 this->groupBoxParamCfg->PerformLayout();
				 (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->numericUpDownParamValue))->EndInit();
				 this->tabControlMain->ResumeLayout(false);
				 this->tabPageMappings->ResumeLayout(false);
				 this->groupBoxConnection->ResumeLayout(false);
				 this->groupBoxConnection->PerformLayout();
				 this->ResumeLayout(false);

			 }
#pragma endregion

#pragma region Main Form event handlers
			 /// <summary>
			 /// Event handler called when main window is first shown.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
	private: System::Void FormMain_Shown(System::Object^  sender, System::EventArgs^  e) {
		// UI Components are all initialized, refresh mappings' tab.
		mappingsChanged();
		// Set connection status to false to update all UI's components
		setConnectionStatus(false);
	}
			 /// <summary>
			 /// Event handler called when main window is closed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void FormMain_FormClosed(System::Object^  sender, System::Windows::Forms::FormClosedEventArgs^  e) {
				 // Disconnect all PCAN-ISO-TP connections.
				 disconnect();
			 }
#pragma endregion

#pragma region Connection > Event Handlers
			 /// <summary>
			 /// Event handler called when button "Hardware Refresh" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonHwRefresh_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPStatus sts;
				 ComboBoxItem ^cbItem;               // an item of the "channel" comboBox
				 TPCANTPHandle pctpHandle;           // temporary PCAN ISO-TP handle
				 TPCANTPHandle pctpHandleSelected;   // store the currently selected channel in the "channel" comboBox
				 UInt32 iBuffer;                     // temporary buffer to retrieve the condition of a channel

				 // Get selected item first (to set it back later).
				 if (comboBoxChannel->SelectedItem != nullptr &&
					 comboBoxChannel->SelectedItem->GetType() == ComboBoxItem::typeid)
					 pctpHandleSelected = (TPCANTPHandle)((ComboBoxItem^)(comboBoxChannel->SelectedItem))->Data;
				 else
					 pctpHandleSelected = CanTpApi::PCANTP_NONEBUS;

				 // Clears the "Channel" comboBox and fill it again with 
				 //  all the PCAN-ISO-TP handles (non-plug'n'play hardware and
				 //  the detected Plug'n'Play hardware).
				 comboBoxChannel->Items->Clear();
				 // Loop through all known PCAN-ISO-TP handles.
				 for (int i = 0; i < m_pctpHandles->Length; i++)
				 {
					 pctpHandle = m_pctpHandles[i];
					 // Initializes an item for the comboBox.
					 cbItem = gcnew ComboBoxItem(CanTpUtils::GetChannelName(pctpHandle), pctpHandle);
					 // Automatically add non-plug'n'play handles.
					 if (pctpHandle <= CanTpApi::PCANTP_DNGBUS1)
						 comboBoxChannel->Items->Add(cbItem);
					 else
					 {
						 // Check the availalility of plug'n'play handles.
						 sts = CanTpApi::GetValue(pctpHandle, TPCANTPParameter::PCANTP_PARAM_CHANNEL_CONDITION, iBuffer, sizeof(UInt32));
						 if (sts == TPCANTPStatus::PCANTP_ERROR_OK &&
							 ((iBuffer & CanTpApi::PCANTP_CHANNEL_AVAILABLE) == CanTpApi::PCANTP_CHANNEL_AVAILABLE))
						 {
							 // Channel is available, add it to the comboBox.
							 comboBoxChannel->Items->Add(cbItem);
						 }
					 }
					 // Select the handle if it was the previously selected one.
					 if (pctpHandle == pctpHandleSelected)
						 comboBoxChannel->SelectedIndex = comboBoxChannel->Items->Count - 1;
				 }
			 }
			 /// <summary>
			 /// Event handler called when button "Initialize" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonInit_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPHandle pctpHandle;
				 TPCANTPBaudrate baudrate;
				 TPCANTPHWType hwType;
				 UInt32 ioPort;
				 Byte interrupt;

				 if (comboBoxChannel->SelectedItem == nullptr)
					 return;
				 // Gets the selected ISO-TP channel.
				 pctpHandle = (TPCANTPHandle)((ComboBoxItem^)(comboBoxChannel->SelectedItem))->Data;
				 // Gets the selected baudrate.
				 baudrate = (TPCANTPBaudrate)(((ComboBoxItem^)(comboBoxBaudrate->SelectedItem))->Data);
				 // Read the HarwareType, IO port and Interrupt only 
				 //  if the selected device is not plug'n'play.
				 hwType = (TPCANTPHWType)0;
				 ioPort = 0;
				 interrupt = 0;
				 if (pctpHandle <= CanTpApi::PCANTP_DNGBUS1)
				 {
					 if (comboBoxHwType->SelectedIndex >= 0)
						 hwType = (TPCANTPHWType)(((ComboBoxItem^)(comboBoxHwType)->SelectedItem)->Data);
					 if (comboBoxIoPort->SelectedIndex >= 0)
						 ioPort = (UInt32)(((ComboBoxItem^)comboBoxIoPort->SelectedItem)->Data);
					 if (comboBoxInterrupt->SelectedIndex >= 0)
						 interrupt = (Byte)(((ComboBoxItem^)comboBoxInterrupt->SelectedItem)->Data);
				 }
				 // Connects to the selected PCAN-ISO-TP channel.
				 connect(pctpHandle, baudrate, hwType, ioPort, interrupt);
			 }
			 /// <summary>
			 /// Event handler called when button "Release" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonRelease_Click(System::Object^  sender, System::EventArgs^  e) {
				 // Disconnects the connected PCAN-ISO-TP channel.
				 disconnect();
			 }
			 /// <summary>
			 /// Event handler called when selection of comboBox "channel handles" is changed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void comboBoxChannel_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPHandle pctpHandle;
				 bool isNotPnp;

				 // Enables "Initialize" button if a channel is selected.
				 buttonInit->Enabled = (comboBoxChannel->SelectedItem != nullptr);
				 // Aborts if no channel is selected.
				 if (comboBoxChannel->SelectedItem == nullptr)
					 return;
				 // Gets the handle from the selected item.
				 pctpHandle = (TPCANTPHandle)((ComboBoxItem^)(comboBoxChannel->SelectedItem))->Data;
				 // Determines if the handle belong to a non-plug'n'play hardware.
				 isNotPnp = (pctpHandle <= CanTpApi::PCANTP_DNGBUS1);
				 // Activates/deactivates configuration controls according to the kind of hardware.
				 comboBoxHwType->Enabled = isNotPnp;
				 comboBoxIoPort->Enabled = isNotPnp;
				 comboBoxInterrupt->Enabled = isNotPnp;
			 }

#pragma endregion

#pragma region Parameters > Event Handlers

			 /// <summary>
			 /// Event handler called when button "Parameters > Get" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamGet_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPParameter param;
				 TPCANTPStatus sts;
				 UInt32 iBuf;
				 StringBuilder ^strBuf;
				 // Checks selection is valid.
				 if (comboBoxParameter->SelectedItem == nullptr || !(comboBoxParameter->SelectedItem->GetType() == ComboBoxItem::typeid))
					 return;
				 // Gets selected parameter
				 param = (TPCANTPParameter)(((ComboBoxItem^)comboBoxParameter->SelectedItem)->Data);
				 iBuf = 0;
				 switch (param)
				 {
					 // Retrieves the API version.
				 case TPCANTPParameter::PCANTP_PARAM_API_VERSION:
					 strBuf = gcnew StringBuilder(256);
					 sts = CanTpApi::GetValue(m_pctpHandle, param, strBuf, 256);
					 checkCanTpStatus(m_pctpHandle, sts, strBuf, param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage("ISO-TP API version:" + strBuf);
					 break;
					 // Reads the ISO-TP BlockSize (BS) parameter (number of Consecutive Frame between Flow Control frames).
				 case TPCANTPParameter::PCANTP_PARAM_BLOCK_SIZE:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("ISO-TP Block Size parameter is {0} ({0:X2}h).", iBuf));
					 break;
					 // Reads if CAN DATA Padding is enabled (if enabled, all segmented CAN frames have a DLC of 8).
				 case TPCANTPParameter::PCANTP_PARAM_CAN_DATA_PADDING:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("CAN Data Padding is {0} ({1}).",
						 (iBuf == CanTpApi::PCANTP_CAN_DATA_PADDING_NONE) ? "disabled" : "enabled", iBuf));
					 break;
					 // Reads the channel's state.
				 case TPCANTPParameter::PCANTP_PARAM_CHANNEL_CONDITION:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK) {
						 switch (iBuf)
						 {
						 case CanTpApi::PCANTP_CHANNEL_AVAILABLE:
							 includeTextMessage(String::Format("Channel {0:X2}h is available ({1}).", m_pctpHandle, iBuf));
							 break;
						 case CanTpApi::PCANTP_CHANNEL_UNAVAILABLE:
							 includeTextMessage(String::Format("Channel {0:X2}h is unavailable ({1}).", m_pctpHandle, iBuf));
							 break;
						 case CanTpApi::PCANTP_CHANNEL_OCCUPIED:
							 includeTextMessage(String::Format("Channel {0:X2}h is occupied ({1}).", m_pctpHandle, iBuf));
							 break;
						 default:
							 includeTextMessage(String::Format("Channel {0:X2}h is in an unknown state ({1}).", m_pctpHandle, iBuf));
							 break;
						 }
					 }
					 break;
					 // Reads if Debug mode is enabled (if enabled, CAN Tx/Rx frames are echoed on console output).
				 case TPCANTPParameter::PCANTP_PARAM_DEBUG:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Debug mode 'CAN frames on console output' is {0} ({1})::",
						 (iBuf == CanTpApi::PCANTP_DEBUG_NONE) ? "disabled" : "enabled", iBuf));
					 break;
					 // Reads if Message Pending Mode is enabled 
					 //  (if enabled, CAN ISO-TP messages with type PCANTP_MESSAGE_INDICATION 
					 //  can be read when the first frame of a segmented message is received)::
				 case TPCANTPParameter::PCANTP_PARAM_MSG_PENDING:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Notifications of incoming CAN-ISO-TP messages are {0} ({1})::",
						 (iBuf == CanTpApi::PCANTP_MSG_PENDING_HIDE) ? "disabled" : "enabled", iBuf));
					 break;
					 // Reads the padding value used when "CAN DATA Padding" is enabled::
				 case TPCANTPParameter::PCANTP_PARAM_PADDING_VALUE:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Value for 'CAN Data Padding' is {0:X2}h ({0})::", iBuf));
					 break;
					 // Reads the ISO-TP default priority value for normal fixed, mixed and enhanced addressing
				 case TPCANTPParameter::PCANTP_PARAM_J1939_PRIORITY:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("The default priority value for normal fixed, mixed and enhanced addressing is {0:X2}h ({0}).", iBuf));
					 break;
					 // Reads the ISO-TP default DLC to use when transmitting messages with CAN FD
				 case TPCANTPParameter::PCANTP_PARAM_CAN_TX_DL:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("The default DLC to use when transmitting messages with CAN FD is {0:X2}h ({0}).", iBuf));
					 break;					 // Reads the receive-event handle (if receive-event is disabled, 0 is returned)::
				 case TPCANTPParameter::PCANTP_PARAM_RECEIVE_EVENT:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Receive event is {0} (event handle is {1:X}h)::",
						 (iBuf == 0) ? "disabled" : "enabled", iBuf));
					 break;
					 // Reads the ISO-TP SeparationTime (STmin) parameter 
					 //  (minimum time to wait between Consecutive Frames transmission)::
				 case TPCANTPParameter::PCANTP_PARAM_SEPARATION_TIME:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
					 {
						 if (iBuf < 0x80)
							 includeTextMessage(String::Format("ISO-TP Separation Time (STmin) is {0}ms ({0:X2}h)::", iBuf));
						 else if (iBuf > 0xF0 && iBuf < 0xFA)
							 includeTextMessage(String::Format("ISO-TP Separation Time (STmin) is {0}s ({0:X2}h)::", (iBuf - 0xF0) * 100));
						 else
							 includeTextMessage(String::Format("ISO-TP Separation Time (STmin) uses a reserved value of ISO 15765 ({0:X2}h)::", iBuf));
					 }
					 break;
					 // Reads the ISO-TP FC::Wait frame transmissions (N_WFTMax) parameter 
					 //  (maximum number of consecutive Flow Control frames with the Wait status after which transmission is aborted)::
				 case TPCANTPParameter::PCANTP_PARAM_WFT_MAX:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Maximum number of FC::Wait frame transmissions (N_WFTMax) is {0}::", iBuf));
					 break;
					 // Generic reading request of a parameter (should not occur)::
				 default:
					 sts = CanTpApi::GetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 checkCanTpStatus(m_pctpHandle, sts, (UInt16)iBuf, (int)param);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
						 includeTextMessage(String::Format("Unknown parameter '{0}' is {1:X2}h", param, iBuf));
					 break;
				 }
				 checkCanTpStatus(sts);
			 }

			 /// <summary>
			 /// Event handler called when button "Parameters > Set" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamSet_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPParameter param;
				 TPCANTPStatus sts;
				 UInt32 iBuf;

				 // Checks selection is valid.
				 if (comboBoxParameter->SelectedItem == nullptr || !(comboBoxParameter->SelectedItem->GetType() == ComboBoxItem::typeid))
					 return;
				 // Sets selected parameter
				 param = (TPCANTPParameter)(((ComboBoxItem^)comboBoxParameter->SelectedItem)->Data);
				 switch (param)
				 {
					 // Sets the ISO-TP BlockSize (BS) parameter (number of Consecutive Frame between Flow Control frames).
				 case TPCANTPParameter::PCANTP_PARAM_BLOCK_SIZE:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets if CAN DATA Padding is enabled (if enabled, all segmented CAN frames have a DLC of 8)::
				 case TPCANTPParameter::PCANTP_PARAM_CAN_DATA_PADDING:
					 iBuf = radioButtonParamActive->Checked ? CanTpApi::PCANTP_CAN_DATA_PADDING_ON : CanTpApi::PCANTP_CAN_DATA_PADDING_NONE;
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets if Debug mode is enabled (if enabled, CAN Tx/Rx frames are echoed on console output)::
				 case TPCANTPParameter::PCANTP_PARAM_DEBUG:
					 iBuf = radioButtonParamActive->Checked ? CanTpApi::PCANTP_DEBUG_CAN : CanTpApi::PCANTP_DEBUG_NONE;
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets if Message Pending Mode is enabled 
					 //  (if enabled, CAN ISO-TP messages with type PCANTP_MESSAGE_INDICATION 
					 //  can be read when the first frame of a segmented message is received)::
				 case TPCANTPParameter::PCANTP_PARAM_MSG_PENDING:
					 iBuf = radioButtonParamActive->Checked ? CanTpApi::PCANTP_MSG_PENDING_SHOW : CanTpApi::PCANTP_MSG_PENDING_HIDE;
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets the padding value used when "CAN DATA Padding" is enabled::
				 case TPCANTPParameter::PCANTP_PARAM_PADDING_VALUE:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets the priority value used when "J1939 Priority" is enabled.
				 case TPCANTPParameter::PCANTP_PARAM_J1939_PRIORITY:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets the DLC value used when "Data Length Code (DLC)" is enabled.
				 case TPCANTPParameter::PCANTP_PARAM_CAN_TX_DL:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;					 // Sets the ISO-TP SeparationTime (STmin) parameter 
					 //  (minimum time to wait between Consecutive Frames transmission)::
				 case TPCANTPParameter::PCANTP_PARAM_SEPARATION_TIME:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Sets the ISO-TP FC::Wait frame transmissions (N_WFTMax) parameter 
					 //  (maximum number of consecutive Flow Control frames with the Wait status after which transmission is aborted)::
				 case TPCANTPParameter::PCANTP_PARAM_WFT_MAX:
					 iBuf = Convert::ToUInt32(numericUpDownParamValue->Value);
					 sts = CanTpApi::SetValue(m_pctpHandle, param, iBuf, sizeof(UInt32));
					 break;
					 // Unhandled parameter (should not occur)::
				 default:
					 includeTextMessage(String::Format("Unknown parameter '{0}', setting aborted::", param));
					 sts = TPCANTPStatus::PCANTP_ERROR_WRONG_PARAM;
					 break;
				 }
				 checkCanTpStatus(m_pctpHandle, sts, (int)param, (int)iBuf);
				 // Outputs the new parameter value::
				 buttonParamGet_Click(this, EventArgs::Empty);
			 }

			 /// <summary>
			 /// Event handler called when button "Parameters > Clear Information" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamInfoClear_Click(System::Object^  sender, System::EventArgs^  e) {
				 // Clears the information of the Information List-Box 
				 listBoxParamInfo->Items->Clear();
			 }

			 /// <summary>
			 /// Event handler called when button "Parameters > Reset" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamReset_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPStatus sts;

				 // Resets the receive and transmit queues of a PCAN Channel.
				 sts = CanTpApi::Reset(m_pctpHandle);
				 checkCanTpStatus(m_pctpHandle, sts);
				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
					 includeTextMessage("Receive and transmit queues successfully reset.");
			 }

			 /// <summary>
			 /// Event handler called when button "Parameters > Status" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamStatus_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPStatus stsResult;
				 String ^errorName;

				 // Gets the current BUS status of a PCAN Channel.
				 stsResult = CanTpApi::GetStatus(m_pctpHandle);
				 // Formats on status
				 switch (stsResult)
				 {
				 case TPCANTPStatus::PCANTP_ERROR_NOT_INITIALIZED:
					 errorName = "PCANTP_ERROR_NOT_INITIALIZED";
					 break;
				 case TPCANTPStatus::PCANTP_ERROR_BUSLIGHT:
					 errorName = "PCANTP_ERROR_BUSLIGHT";
					 break;
				 case TPCANTPStatus::PCANTP_ERROR_BUSHEAVY: // TPCANTPStatus.PCANTP_ERROR_BUSWARNING
					 errorName = "PCANTP_ERROR_BUSHEAVY";
					 break;
				 case TPCANTPStatus::PCANTP_ERROR_BUSOFF:
					 errorName = "PCANTP_ERROR_BUSOFF";
					 break;
				 case TPCANTPStatus::PCANTP_ERROR_OK:
					 errorName = "PCANTP_ERROR_OK";
					 break;
				 default:
					 errorName = "See Documentation";
					 break;
				 }
				 // Displays Message
				 includeTextMessage(String::Format("Channel status: {0} ({1:X}h)", errorName, stsResult));
			 }

			 /// <summary>
			 /// Event handler called when button "Parameters > Version" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonParamVersion_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPStatus sts;
				 StringBuilder ^strTemp;

				 //Gets the vesion of the ISO-TP API
				 strTemp = gcnew StringBuilder(256);
				 sts = CanTpApi::GetValue(CanTpApi::PCANTP_NONEBUS,
					 TPCANTPParameter::PCANTP_PARAM_API_VERSION, strTemp, 256);
				 checkCanTpStatus(CanTpApi::PCANTP_NONEBUS, sts, strTemp, TPCANTPParameter::PCANTP_PARAM_API_VERSION);
				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 includeTextMessage("API Version: " + strTemp->ToString());
				 }
			 }

			 /// <summary>
			 /// Event handler called when the selection of the comboBox "Parameters" is changed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void comboBoxParameter_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPParameter param;
				 bool isRadioEnabled, isNudEnabled, isSetEnabled, isGetEnabled;
				 UInt32 nudMaxValue, nudMinValue, nudDefaultValue;

				 nudMinValue = 0x00;
				 nudMaxValue = 0xFF;
				 nudDefaultValue = 0x00;
				 isRadioEnabled = false;
				 isNudEnabled = false;
				 isSetEnabled = false;
				 isGetEnabled = false;
				 if (comboBoxParameter->SelectedItem != nullptr &&
					 comboBoxParameter->SelectedItem->GetType() == ComboBoxItem::typeid)
				 {
					 isGetEnabled = isConnected();
					 // Activates/deactivates controls according to the selected parameter 
					 param = (TPCANTPParameter)(((ComboBoxItem^)(comboBoxParameter->SelectedItem))->Data);
					 switch (param)
					 {
					 case TPCANTPParameter::PCANTP_PARAM_API_VERSION:
						 isGetEnabled = true;
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_BLOCK_SIZE:
						 isNudEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_CAN_DATA_PADDING:
						 isRadioEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_CHANNEL_CONDITION:
						 isGetEnabled = true;
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_DEBUG:
						 isRadioEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_MSG_PENDING:
						 isRadioEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_PADDING_VALUE:
						 isNudEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_J1939_PRIORITY:
						 isNudEnabled = true;
						 nudMaxValue = 0x07;
						 nudDefaultValue = 0x06;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_CAN_TX_DL:
						 isNudEnabled = true;
						 nudMaxValue = 0x0F;
						 nudMinValue = 0x08;
						 nudDefaultValue = 0x08;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_RECEIVE_EVENT:
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_SEPARATION_TIME:
						 isNudEnabled = true;
						 isSetEnabled = isConnected();
						 break;
					 case TPCANTPParameter::PCANTP_PARAM_WFT_MAX:
						 isGetEnabled = true;
						 isNudEnabled = true;
						 isSetEnabled = true;
						 nudMaxValue = 0xFFFF;
						 break;
					 }
				 }
				 // Activates/deactivates controls
				 buttonParamGet->Enabled = isGetEnabled;
				 buttonParamSet->Enabled = isSetEnabled;
				 radioButtonParamActive->Enabled = isRadioEnabled;
				 radioButtonParamInactive->Enabled = isRadioEnabled;
				 numericUpDownParamValue->Enabled = isNudEnabled;
				 numericUpDownParamValue->Maximum = nudMaxValue;
				 numericUpDownParamValue->Minimum = nudMinValue;
				 numericUpDownParamValue->Value = nudDefaultValue;
			 }

#pragma endregion

#pragma region Mapping > Event Handlers

			 /// <summary>
			 /// Event handler called when button "Add Mapping" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMappingAdd_Click(System::Object^  sender, System::EventArgs^  e) {
				 // Prepares dialogBox's UI components with a default mapping.
				 m_dlgMapping->initializeMapping(nullptr);
				 // Shows dialog
				 if (m_dlgMapping->ShowDialog() == System::Windows::Forms::DialogResult::OK)
				 {
					 // Clones the mapping from the dialogBox and adds it to the API.
					 mappingsAdd(m_dlgMapping->m_mapping->Clone());
					 // Refreshes UI dealing with mappings.
					 mappingsChanged();
				 }
			 }

			 /// <summary>
			 /// Event handler called when button "Delete Mapping" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMappingDel_Click(System::Object^  sender, System::EventArgs^  e) {
				 // Asserts the selection is valid
				 if (listViewMappings->SelectedItems->Count > 0 &&
					 listViewMappings->SelectedItems[0]->Tag->GetType() == MappingStatus::typeid)
				 {
					 MappingStatus ^mapping;
					 TPCANTPStatus sts;

					 // Gets the selected mapping.
					 mapping = (MappingStatus^)(listViewMappings->SelectedItems[0]->Tag);
					 // Prevent deletion of "automatic mapping" 
					 //  (those mappings do not exist in the ISO-TP API, they are displayed
					 //  as a tutorial purpose)
					 if (mapping->IsAutomatic)
						 return;
					 // Removes the mapping from the API (via the CAN ID that defines it uniquely)
					 sts = CanTpApi::RemoveMapping(m_pctpHandle, mapping->m_canId);
					 checkCanTpStatus(m_pctpHandle, sts, (int)mapping->m_canId);
					 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
					 {
						 // Removes the mapping from the internal list of mappings
						 m_mappings->Remove(mapping);
						 // Removes the corresponding listViewItem 
						 listViewMappings->Items->Remove(listViewMappings->SelectedItems[0]);
					 }
				 }
			 }

			 /// <summary>
			 /// Event handler called when button "Mapping example" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMappingSample_Click(System::Object^  sender, System::EventArgs^  e) {
				 MappingStatus ^mapping;
				 Byte clientAddr;    // Tester Client address
				 Byte ecuAddr;       // ECU address
				 Byte funcAddr;      // Functional address
				 UInt32 canIdCli2Ecu;  // CAN ID used to communicate from Client to ECU
				 UInt32 canIdEcu2Cli;  // CAN ID used to communicate from ECU to Client
				 UInt32 canIdCliFunc;  // CAN ID used to communicate from Client to any ECUs

				 // The sample defines 11 bits CAN ID, normal format addressing mappings 
				 //  (diagnostic message will be mandatory since normal format addressing is used)
				 clientAddr = 0xF1;
				 ecuAddr = 0x13;
				 funcAddr = 0x20;
				 canIdCli2Ecu = 0xA1;
				 canIdEcu2Cli = 0xA2;
				 canIdCliFunc = 0xA3;
				 // Defines a mapping to allow communication from client to ECU (a.k.a request).
				 mapping = gcnew MappingStatus(canIdCli2Ecu, canIdEcu2Cli,
					 TPCANTPIdType::PCANTP_ID_CAN_11BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_NORMAL,
					 TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL,
					 clientAddr, ecuAddr, 0x00);
				 mappingsAdd(mapping);
				 // Defines a mapping to allow communication from ECU to client (a.k.a response).
				 mapping = gcnew MappingStatus(canIdEcu2Cli, canIdCli2Ecu,
					 TPCANTPIdType::PCANTP_ID_CAN_11BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_NORMAL,
					 TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL,
					 ecuAddr, clientAddr, 0x00);
				 mappingsAdd(mapping);
				 // define mapping to allow communication from client to any ECUs (a.k.a functional request).
				 mapping = gcnew MappingStatus(canIdCliFunc, CanTpApi::CAN_ID_NO_MAPPING,
					 TPCANTPIdType::PCANTP_ID_CAN_11BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_NORMAL,
					 TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL,
					 clientAddr, funcAddr, 0x00);
				 mappingsAdd(mapping);
				 // Refreshes all UIs dealing with mappings.
				 mappingsChanged();
			 }

			 /// <summary>
			 /// Event handler called when selection of listview "mapping" is changed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void listViewMappings_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
				 bool enabled;

				 // Enable/disable "remove mapping" button based on listView's selection 
				 enabled = (listViewMappings->SelectedItems->Count > 0);
				 if (enabled)
				 {
					 // Also do not allow removal of "automatic mapping" (since its a cosmetic display).
					 MappingStatus ^mapping = (MappingStatus^)(listViewMappings->SelectedItems[0]->Tag);
					 if (mapping != nullptr && mapping->IsAutomatic)
						 enabled = false;
				 }
				 // Updates button status.
				 buttonMappingDel->Enabled = enabled;
			 }

#pragma endregion

#pragma region Messages > Read Event Handlers

			 /// <summary>
			 /// Event handler called when button "Clear message" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMsgClear_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPStatus sts;

				 // Clears ISO-TP Rx/Tx queues only if channel is connected.
				 if (isConnected())
				 {
					 sts = CanTpApi::Reset(m_pctpHandle);
					 checkCanTpStatus(m_pctpHandle, sts);
				 }
				 // Clears "received messages" listview and internal list of received messages.
				 Monitor::Enter(m_receiveMsgs->SyncRoot);
				 try {
					 m_receiveMsgs->Clear();
					 listViewMsgs->Items->Clear();
				 }
				 finally {
					 Monitor::Exit(m_receiveMsgs->SyncRoot);
				 }
			 }

			 /// <summary>
			 /// Event handler called when button "Read message" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMsgRead_Click(System::Object^  sender, System::EventArgs^  e) {
				 // Reads one ISO-TP message.
				 readMessage();
			 }

			 /// <summary>
			 /// Event handler called when the value of the checkBox "Show Timestamp as period" is changed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void checkBoxMsgShowPeriod_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
				 // According to the check-value of this checkbox,
				 //  the received time of a messages will be interpreted as a
				 //  period (time between the two last messages) or as time-stamp
				 //  (the elapsed time since windows was started).
				 Monitor::Enter(m_receiveMsgs->SyncRoot);
				 try {
					 for each(MessageStatus^ msg in m_receiveMsgs)
						 msg->ShowingPeriod = checkBoxMsgShowPeriod->Checked;
				 }
				 finally {
					 Monitor::Exit(m_receiveMsgs->SyncRoot);
				 }
			 }

			 /// <summary>
			 /// Event handler called when radioButton "Reading Type" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 void radioButtonMsgRead_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
			 {
				 // Terminates "read" thread if it exists.
				 if (m_readThread != nullptr)
				 {
					 m_readThread->Abort();
					 m_readThread->Join();
					 m_readThread = nullptr;
				 }
				 // Disables "read" timer.
				 timerRead->Enabled = false;
				 // Updates enable state of manual read button.
				 buttonMsgRead->Enabled = isConnected() && radioButtonMsgManual->Checked;
				 // Updates timer that diplays new messages.
				 timerDisplay->Enabled = isConnected();
				 // Aborts function if no channel is connected.
				 if (!isConnected())
					 return;
				 // According to the kind of reading, either a timer, a thread or a button is enabled.
				 if (radioButtonMsgTimer->Checked)
				 {
					 // Enables Timer.
					 timerRead->Enabled = isConnected();
				 }
				 else if (radioButtonMsgEvent->Checked)
				 {
					 // Creates and starts the tread to read CAN ISO-TP Message using PCANTP_PARAM_RECEIVE_EVENT.
					 System::Threading::ThreadStart ^threadDelegate = gcnew System::Threading::ThreadStart(this, &FormMain::pctpReadThread);
					 m_readThread = gcnew System::Threading::Thread(threadDelegate);
					 m_readThread->IsBackground = true;
					 m_readThread->Start();
				 }
			 }

			 /// <summary>
			 /// Event handler called periodically to update the display of received messages.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void timerDisplay_Tick(System::Object^  sender, System::EventArgs^  e) {
				 displayMessages();
			 }

			 /// <summary>
			 /// Event handler called periodically to read new ISO-TP messages.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void timerRead_Tick(System::Object^  sender, System::EventArgs^  e) {
				 // Try to read new messages.
				 readMessages();
			 }

#pragma endregion

#pragma region Messages > Write Event Handlers

			 /// <summary>
			 /// Event handler called when the button "Fill message's data" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMsgDataFill_Click(System::Object^  sender, System::EventArgs^  e) {
				 StringBuilder ^buf;
				 String ^byteStr;

				 // Generates a 4095-bytes String (each byte is increased by 1)
				 buf = gcnew StringBuilder(4095 * 2);
				 for (int i = 1, count = 0; count < (4095 * 2); i++, count += 2)
				 {
					 byteStr = String::Format("{0:X2}", i % 256, 16);
					 buf->Append(byteStr[0]);
					 buf->Append(byteStr[1]);
				 }
				 // Sets the data according to its length
				 textBoxMsgData->Text = buf->ToString()->Substring(0, textBoxMsgData->MaxLength)->ToUpper();
			 }

			 /// <summary>
			 /// Event handler called when the button "Write message" is clicked.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void buttonMsgWrite_Click(System::Object^  sender, System::EventArgs^  e) {
				 TPCANTPMsg ^msg = gcnew TPCANTPMsg();
				 MappingStatus ^mapping;
				 TPCANTPStatus sts;
				 String ^strByte;

				 // Asserts a mapping to write is selected.
				 if (comboBoxMsgMapping->SelectedItem == nullptr)
					 return;
				 // Gets the selected mapping and asserts it is valid.
				 mapping = (MappingStatus^)(((ComboBoxItem^)comboBoxMsgMapping->SelectedItem)->Data);
				 if (mapping == nullptr)
					 return;
				 // Initializes the TPCANTPMsg to send with the selected mapping.
				 msg->IDTYPE = mapping->m_canIdType;
				 msg->FORMAT = mapping->m_formatType;
				 msg->MSGTYPE = mapping->m_msgType;
				 msg->TA_TYPE = mapping->m_targetType;
				 if (mapping->IsAutomatic)
				 {
					 // Be cautious with Enhanced format addressing which uses 11 bits for addresses
					 if (mapping->m_formatType != TPCANTPFormatType::PCANTP_FORMAT_ENHANCED)
					 {
						 msg->SA = Convert::ToByte(numericUpDownSourceAddr->Value);
						 msg->TA = Convert::ToByte(numericUpDownTargetAddr->Value);
						 msg->RA = Convert::ToByte(numericUpDownRemoteAddr->Value);
					 }
					 else
					 {
						 // Enhanced format addressing uses 11 bits for its addresses,
						 //  in this case Remote address is used to store the extra bits
						 //  from Source and Target addresses.
						 UInt32 iBuf;
						 // Unique SA is 11bits: store bits [7..0] in SA
						 // and the rest in [7..4] of RA
						 iBuf = Convert::ToUInt32(numericUpDownSourceAddr->Value);
						 msg->SA = (Byte)iBuf;
						 msg->RA = (Byte)((iBuf >> 8) << 4);
						 // Unique TA is 11bits: store bits [7..0] in TA
						 // and the rest in [3..0] of RA
						 iBuf = Convert::ToUInt32(numericUpDownTargetAddr->Value);
						 msg->TA = (Byte)iBuf;
						 msg->RA |= (Byte)(iBuf >> 8);
					 }
				 }
				 else
				 {
					 // The mapping defines the addresses.
					 msg->SA = mapping->m_sourceAddr;
					 msg->TA = mapping->m_targetAddr;
					 msg->RA = mapping->m_remoteAddr;
				 }
				 // Initializes RESULT now to avoid a strange behaviour within Visual Studio while debugging (C++.NET issue).
				 msg->RESULT = TPCANTPConfirmation::PCANTP_N_OK;
				 // Sets length and data.
				 msg->LEN = Convert::ToUInt16(numericUpDownMsgLength->Value);
				 msg->DATA = gcnew array<Byte>(4095);
				 for (int i = 0; i < msg->LEN; i++)
				 {
					 if (i * 2 < textBoxMsgData->TextLength - 1)
						 strByte = textBoxMsgData->Text->Substring(i * 2, 2);
					 else if (i * 2 < textBoxMsgData->TextLength)
						 strByte = textBoxMsgData->Text->Substring(i * 2, 1);
					 else
						 strByte = "0";
					 msg->DATA[i] = Convert::ToByte(strByte, 16);
				 }
				 // CAN FD support
				 if (checkBoxFDMessage->Checked)
				 {
					 msg->IDTYPE = msg->IDTYPE | TPCANTPIdType::PCANTP_ID_CAN_FD;
					 // if BRS support
					 if (checkBoxBRS->Checked)
					 {
						 msg->IDTYPE = msg->IDTYPE | TPCANTPIdType::PCANTP_ID_CAN_BRS;
					 }
				 }
				 if (checkBoxHasPriority->Checked)
				 {
					 // Manage priority (available only in 29 bits mixed of fixed normal)
					 if ((mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_FIXED_NORMAL) || (mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_MIXED) ||
						 mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_ENHANCED)
					 {
						 if (TPCANTPIdTypePriority::PCANTP_ID_CAN_IS_EXTENDED((Byte)msg->IDTYPE))
						 {
							 msg->IDTYPE = msg->IDTYPE | (TPCANTPIdType)CanTpApi::PCANTP_ID_CAN_IS_PRIORITY_MASK;
							 // Clean old priority
							 msg->IDTYPE = msg->IDTYPE & (TPCANTPIdType)CanTpApi::PCANTP_ID_CAN_MASK + (TPCANTPIdType)CanTpApi::PCANTP_ID_CAN_IS_PRIORITY_MASK;
							 // Add priority value
							 msg->IDTYPE = msg->IDTYPE | (TPCANTPIdType)((int)numericUpDownPriority->Value << 5);
						 }
					 }
				 }
				 // Sends the message to the Tx queue of the API.
				 sts = CanTpApi::Write(m_pctpHandle, *msg);
				 checkCanTpStatus(m_pctpHandle, sts, msg);
			 }

			 /// <summary>
			 /// Event handler called when selection of comboBox "Write mapping" is changed.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void comboBoxMsgMapping_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
				 MappingStatus ^mapping;
				 bool enabled;

				 // Asserts a mapping is selected.
				 mapping = nullptr;
				 if (comboBoxMsgMapping->SelectedItem != nullptr)
				 {
					 // Gets the selected mapping.
					 mapping = (MappingStatus^)(((ComboBoxItem^)(comboBoxMsgMapping->SelectedItem))->Data);
					 // Enables the button to write the message.
					 buttonMsgWrite->Enabled = true;
					 // Source (SA), Target (TA) and Remote address (RA) textboxes are 
					 //  enabled ONLY if the mapping allows dynamic 
					 //  generation of CAN ID based on SA, TA, RA.
					 //  i.e. only if an "automatic mapping" is selected.
					 enabled = mapping->IsAutomatic;
					 numericUpDownSourceAddr->Enabled = enabled;
					 numericUpDownTargetAddr->Enabled = enabled;
					 // RA is also only available with Remote Diagnostic Messages.
					 if (mapping->m_msgType == TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC)
					 {
						 numericUpDownRemoteAddr->Enabled = enabled;
					 }
					 else
					 {
						 numericUpDownRemoteAddr->Enabled = false;
						 // To avoid confusion, RA text is reset to 0x00.
						 numericUpDownRemoteAddr->Text = "0";
					 }
					 // Sets SA/TA maximum values (default is 8bits, but Enhanced addressing uses 11bits for SA and TA
					 numericUpDownSourceAddr->Maximum = (mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_ENHANCED) ? 0x7FF : 0xFF;
					 numericUpDownTargetAddr->Maximum = numericUpDownSourceAddr->Maximum;
					 // Sets SA/TA/RA as defined in the mapping.
					 // If an "automatic mapping" is selected,
					 //  then the user has to set those value.
					 if (!mapping->IsAutomatic)
					 {
						 numericUpDownSourceAddr->Value = mapping->m_sourceAddr;
						 numericUpDownTargetAddr->Value = mapping->m_targetAddr;
						 numericUpDownRemoteAddr->Value = mapping->m_remoteAddr;
					 }
					 // Sets the maximum size of the ISO-TP message.
					 if (mapping->m_targetType == TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL)
					 {
						 // Functional addressing allows only Single Frame to be sent
						 numericUpDownMsgLength->Maximum = CanTpUtils::ISOTP_MSG_FUNC_MAX_LENGTH;
						 if (mapping->m_formatType != TPCANTPFormatType::PCANTP_FORMAT_NORMAL &&
							 mapping->m_formatType != TPCANTPFormatType::PCANTP_FORMAT_FIXED_NORMAL)
							 numericUpDownMsgLength->Maximum--;
					 }
					 else
						 numericUpDownMsgLength->Maximum = CanTpUtils::ISOTP_MSG_PHYS_MAX_LENGTH;
					 if (((mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_FIXED_NORMAL) || (mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_MIXED) ||
						 mapping->m_formatType == TPCANTPFormatType::PCANTP_FORMAT_ENHANCED) && mapping->m_canIdType == TPCANTPIdType::PCANTP_ID_CAN_29BIT)
					 {
						 // If it is a 29bits mapping fixed normal, enhanced or mixed, changing "Priority" value is allowed
						 checkBoxHasPriority->Enabled = true;
					 }
					 else
					 {
						 checkBoxHasPriority->Enabled = false;
						 checkBoxHasPriority->Checked = false;
						 numericUpDownPriority->Enabled = false;
					 }
				 }
				 // No mapping is selected in comboBox.
				 else
				 {
					 // Disables "write message" UI components.
					 enabled = false;
					 buttonMsgWrite->Enabled = enabled;
					 numericUpDownSourceAddr->Enabled = enabled;
					 numericUpDownTargetAddr->Enabled = enabled;
					 numericUpDownRemoteAddr->Enabled = enabled;
				 }
			 }

			 /// <summary>
			 /// Event handler called when numericUpDown of "Message's length" is changed,
			 /// or textBoxMsgData is left.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 System::Void numericUpDownMsgLength_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
				 // Gets the size of the text based on the data length.
				 // Note: each byte is translated in 2 characters.
				 textBoxMsgData->MaxLength = Convert::ToInt32(numericUpDownMsgLength->Value) * 2;
				 // Adds a zero to the last "non-two-character" byte (ex. 0xF => 0x0F ; 0xFA1 => 0xFA01)
				 if (textBoxMsgData->Text->Length % 2 == 1)
					 textBoxMsgData->Text = textBoxMsgData->Text->Insert(textBoxMsgData->Text->Length - 1, "0");
				 // Modify data string based on the new length
				 if (textBoxMsgData->Text->Length > textBoxMsgData->MaxLength)
					 // Data is longer than the length, truncates the string
					 textBoxMsgData->Text = textBoxMsgData->Text->Substring(0, textBoxMsgData->MaxLength);
				 else
					 // Data is shroter than the length, pads the string with zeros
					 textBoxMsgData->Text = textBoxMsgData->Text->PadRight(textBoxMsgData->MaxLength, '0');
			 }

			 /// <summary>
			 /// Event handler called when a key is pressed inside "Write message Data" textBox.
			 /// </summary>
			 /// <param name="sender">The source of the event.</param>
			 /// <param name="e">Information on the event.</param>
			 void textBoxHexOnly_KeyPress(System::Object^  sender, System::Windows::Forms::KeyPressEventArgs^  e)
			 {
				 char chCheck;

				 // Converts the Character to its Upper case equivalent
				 chCheck = (char)Char::ToUpper(e->KeyChar);
				 // Key is the Delete (Backspace) Key
				 if (chCheck == 8)
					 return;
				 e->KeyChar = chCheck;
				 // Key is a number between 0-9
				 if ((chCheck > 47) && (chCheck < 58))
					 return;
				 // Key is a character between A-F
				 if ((chCheck > 64) && (chCheck < 71))
					 return;
				 // key is neither a number nor a character between A(a) and F(f)
				 e->Handled = true;
			 }

#pragma endregion

#pragma region Controllers handling ISO-TP connection

			 /// <summary>
			 /// Connects to a PCAN ISO-TP channel and sets m_pctpHandle.
			 /// </summary>
			 /// <param name="canHandle">A PCANTP Channel Handle representing a PCANTP-Client</param>
			 /// <param name="baudrate">The CAN Hardware speed</param>
			 /// <param name="hwType">Non plug-'n-play: The type of hardware and operation mode</param>
			 /// <param name="ioPort">Non plug-'n-play: The I/O address for the parallel port</param>
			 /// <param name="interrupt">Non plug-'n-play: Interrupt number of the parallel port</param>
			 /// <returns>true is returned on success</returns>
			 bool connect(TPCANTPHandle canHandle, TPCANTPBaudrate baudrate, TPCANTPHWType hwType, UInt32 ioPort, Byte interrupt)
			 {
				 TPCANTPStatus sts;

				 // Connects to the selected PCAN-ISO-TP channel.
				 // If FD support
				 if (checkBoxCanFd->Checked)
				 {
					 // Convert unicode string to multibytes char
					 sts = CanTpApi::InitializeFD(canHandle, textBoxCanFdBitrate->Text);
					 checkCanTpStatus(canHandle, sts, System::Text::Encoding::UTF8->GetBytes(textBoxCanFdBitrate->Text->ToString()));
				 }
				 else
				 {
					 // Connects to the selected PCAN-ISO-TP channel.
					 sts = CanTpApi::Initialize(canHandle, baudrate, hwType, ioPort, interrupt);
					 checkCanTpStatus(canHandle, sts, (int)baudrate, (int)hwType, (int)ioPort, interrupt);
				 }
				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 // Stores the currently connected channel.
					 m_pctpHandle = canHandle;
					 // Clear mappings.
					 mappingsInit();
					 mappingsChanged();
					 // Desable FD checkbox
					 checkBoxCanFd->Enabled = false;
				 }
				 else
					 m_pctpHandle = CanTpApi::PCANTP_NONEBUS;
				 // Sets the connection status of the main-form.
				 setConnectionStatus(sts == TPCANTPStatus::PCANTP_ERROR_OK);

				 return (m_pctpHandle != CanTpApi::PCANTP_NONEBUS);
			 }

			 /// <summary>
			 /// Disconnects the currently connected channel (m_pctpHandle)
			 /// </summary>
			 /// <returns>true is returned on success</returns>
			 bool disconnect()
			 {
				 TPCANTPStatus sts;

				 // Disconnects from selected PCAN-ISO-TP channel
				 sts = CanTpApi::Uninitialize(m_pctpHandle);
				 checkCanTpStatus(m_pctpHandle, sts);
				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 // Resets channel and stored mappings.
					 m_pctpHandle = CanTpApi::PCANTP_NONEBUS;
					 // Resets stored mappings.
					 m_mappings->Clear();
					 mappingsChanged();
					 checkBoxHasPriority->Checked = false;
					 checkBoxHasPriority->Enabled = false;
					 numericUpDownPriority->Enabled = false;
					 // enable FD checkbox
					 checkBoxCanFd->Enabled = true;
				 }
				 // Sets the connection status of the main-form
				 setConnectionStatus(sts != TPCANTPStatus::PCANTP_ERROR_OK);
				 return isConnected();
			 }

#pragma endregion

#pragma region Controllers handling ISO-TP mappings

			 /// <summary>
			 /// Sets the default "automatic" mappings.
			 /// Those mappings are set for tutorial/understanding purpose,
			 /// ISO-TP API handles internally CANTP messages with those
			 /// network information and do not require mappings to be defined.
			 /// </summary>
			 void mappingsInit()
			 {
				 MappingStatus ^mapping;

				 // Initializes the internal list of mappings
				 if (m_mappings == nullptr)
					 m_mappings = gcnew List<MappingStatus^>();
				 else
					 m_mappings->Clear();

				 // 29 bits CAN ID, Normal Fixed and physical addressing
				 mapping = gcnew MappingStatus(0, 0, TPCANTPIdType::PCANTP_ID_CAN_29BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_FIXED_NORMAL, TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0);
				 m_mappings->Add(mapping);
				 // 29 bits CAN ID, Normal Fixed and functional addressing
				 mapping = gcnew MappingStatus(0, 0, TPCANTPIdType::PCANTP_ID_CAN_29BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_FIXED_NORMAL, TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL, 0, 0, 0);
				 m_mappings->Add(mapping);
				 // 29 bits CAN ID, Mixed and physical addressing
				 mapping = gcnew MappingStatus(0, 0, TPCANTPIdType::PCANTP_ID_CAN_29BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_MIXED, TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0);
				 m_mappings->Add(mapping);
				 // 29 bits CAN ID, Mixed and functional addressing
				 mapping = gcnew MappingStatus(0, 0, TPCANTPIdType::PCANTP_ID_CAN_29BIT,
					 TPCANTPFormatType::PCANTP_FORMAT_MIXED, TPCANTPMessageType::PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_FUNCTIONAL, 0, 0, 0);
				 m_mappings->Add(mapping);
				 mapping = gcnew MappingStatus(0, 0, TPCANTPIdType::PCANTP_ID_CAN_29BIT,
					 // 29 bits CAN ID, Enhanced and physical addressing (ISO 15765-3)
					 TPCANTPFormatType::PCANTP_FORMAT_ENHANCED, TPCANTPMessageType::PCANTP_MESSAGE_DIAGNOSTIC,
					 TPCANTPAddressingType::PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0);
				 m_mappings->Add(mapping);
			 }

			 /// <summary>
			 /// Sets a new mapping to the ISO-TP API.
			 /// </summary>
			 /// <param name="mapping"></param>
			 void mappingsAdd(MappingStatus ^mapping)
			 {
				 TPCANTPStatus sts;

				 // Adds the mapping inside the API
				 sts = CanTpApi::AddMapping(m_pctpHandle, mapping->m_canId, mapping->m_canIdResponse,
					 mapping->m_canIdType, mapping->m_formatType, mapping->m_msgType,
					 mapping->m_sourceAddr, mapping->m_targetAddr, mapping->m_targetType, mapping->m_remoteAddr);
				 checkCanTpStatus(m_pctpHandle, sts, mapping);

				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 // Adds the mapping to the internal list of configured mappings.
					 m_mappings->Add(mapping);
				 }
			 }

			 /// <summary>
			 /// Function to be called when a change occured in the configured mappings.
			 /// The function updates all UI components according to the new settings.
			 /// </summary>
			 void mappingsChanged()
			 {
				 MappingStatus ^mappingComboSel;   // selected mapping in comboBoxMsgMapping
				 MappingStatus ^mappingListSel;    // selected mapping in listViewMappings
				 MappingStatus ^mapping;
				 ListViewItem ^lvi;

				 mappingComboSel = nullptr;
				 mappingListSel = nullptr;
				 // Store selected item in mappingListSel.
				 if (listViewMappings->SelectedItems->Count > 0)
					 mappingListSel = (MappingStatus^)(listViewMappings->SelectedItems[0]->Tag);
				 // Store selected item in comboBoxMsgMapping.
				 if (comboBoxMsgMapping->SelectedItem != nullptr)
					 mappingComboSel = (MappingStatus^)((ComboBoxItem^)(comboBoxMsgMapping->SelectedItem))->Data;

				 // Clear listview of mappings.
				 listViewMappings->Items->Clear();
				 // Clear comboBox of mappings in "write message" section.
				 comboBoxMsgMapping->Items->Clear();
				 // Loop through all configured mappings and add them to UI.
				 for (int i = 0; i < m_mappings->Count; i++)
				 {
					 mapping = m_mappings[i];
					 // Add mapping to listView of mappings.
					 lvi = gcnew ListViewItem();
					 lvi->Tag = mapping;
					 lvi->Text = mapping->CanId;
					 lvi->SubItems->Add(mapping->CanIdResponse);
					 lvi->SubItems->Add(mapping->TargetType);
					 lvi->SubItems->Add(mapping->CanIdType);
					 lvi->SubItems->Add(mapping->SourceAddress);
					 lvi->SubItems->Add(mapping->TargetAddress);
					 lvi->SubItems->Add(mapping->MsgType);
					 lvi->SubItems->Add(mapping->FormatType);
					 lvi->SubItems->Add(mapping->RemoteAddress);
					 listViewMappings->Items->Add(lvi);
					 if (mapping->Equals(mappingComboSel))
						 lvi->Selected = true;
					 // Add mapping to comboBox of mappings in the messages/write tab.
					 comboBoxMsgMapping->Items->Add(gcnew ComboBoxItem(mapping->Name, mapping));
					 if (mapping->Equals(mappingComboSel))
						 comboBoxMsgMapping->SelectedIndex = i;
				 }
			 }

#pragma endregion

#pragma region Controllers handling ISO-TP messages
			 /// <summary>
			 /// Reads several ISO-TP messages from the bus CAN.
			 /// </summary>
			 void readMessages()
			 {
				 TPCANTPStatus sts;

				 // We read at least one time the queue looking for messages.
				 // If a message is found, we look again trying to find more.
				 // If the queue is empty or an error occurr, we get out from
				 // the dowhile statement.
				 do
				 {
					 sts = readMessage();
				 } while (isConnected() && sts == TPCANTPStatus::PCANTP_ERROR_OK);
			 }

			 /// <summary>
			 /// Reads an ISO-TP messages from the bus CAN.
			 /// </summary>
			 /// <returns>A TPCANTPStatus error code</returns>
			 TPCANTPStatus readMessage()
			 {
				 TPCANTPMsg msg;
				 TPCANTPTimestamp ts;
				 TPCANTPStatus sts;

				 // Reads and process a single ISO-TP message
				 sts = CanTpApi::Read(m_pctpHandle, msg, ts);
				 if (sts == TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 processMessage(msg, ts);
					 checkCanTpStatus(m_pctpHandle, sts, msg);
				 }
				 return sts;
			 }

			 /// <summary>
			 /// Processes a received message, in order to show it in the Message-ListView
			 /// </summary>
			 /// <param name="msgRcvd">The received ISO-TP message</param>
			 void processMessage(TPCANTPMsg msgRcvd, TPCANTPTimestamp ts)
			 {
				 // Prevent concurrent access (reading thread and UI event can alter the list)	
				 Monitor::Enter(m_receiveMsgs->SyncRoot);
				 try {
					 // Searches if the message has already been received 
					 //  (same Network Address Information) or if it is a new message.
					 for each(Object^ msg in m_receiveMsgs)
					 {
						 if (((MessageStatus^)msg)->isSameNetAddrInfo(msgRcvd))
						 {
							 // Modifies the existing message and exit
							 ((MessageStatus^)msg)->update(msgRcvd, ts);
							 return;
						 }
					 }
					 // Message not found, it will be created
					 insertMsgEntry(msgRcvd, ts);
				 }
				 finally {
					 Monitor::Exit(m_receiveMsgs->SyncRoot);
				 }

			 }

			 /// <summary>
			 /// Inserts a new entry for a new message in the Message-ListView
			 /// </summary>
			 /// <param name="msg">The messasge to be inserted</param>
			 /// <param name="ts">The Timesamp of the new message</param>
			 void insertMsgEntry(TPCANTPMsg msg, TPCANTPTimestamp ts)
			 {
				 MessageStatus ^msgSts;   // MessageStatus corresponding to the new TPCANTPMsg
				 ListViewItem ^lvi;       // ListView Item corresponding to the MessageStatus
				 ListViewItem::ListViewSubItem ^lviSub;    // SubItem of the listView Item

				 Monitor::Enter(m_receiveMsgs->SyncRoot);
				 try {
					 // Adds a new MessageStatus in the received-message list.
					 msgSts = gcnew MessageStatus(msg, ts, listViewMsgs->Items->Count);
					 msgSts->ShowingPeriod = checkBoxMsgShowPeriod->Checked;
					 m_receiveMsgs->Add(msgSts);
					 // Adds a corresponding new item in the message listView
					 lvi = listViewMsgs->Items->Add(msgSts->SourceAddress);
					 lvi->UseItemStyleForSubItems = false;
					 lvi->SubItems->Add(msgSts->TargetAddress);
					 lvi->SubItems->Add(msgSts->RemoteAddress);
					 lvi->SubItems->Add(msgSts->CanIdType);
					 lvi->SubItems->Add(msgSts->MsgType);
					 lvi->SubItems->Add(msgSts->FormatType);
					 lvi->SubItems->Add(msgSts->TargetType);
					 lviSub = lvi->SubItems->Add(msgSts->ResultString);
					 // Highlights network ISO-TP error in red
					 if (msgSts->CanTpMsg.RESULT != TPCANTPConfirmation::PCANTP_N_OK)
						 lviSub->ForeColor = Color::Red;
					 lvi->SubItems->Add(msgSts->LengthString);
					 lvi->SubItems->Add(Convert::ToString(msgSts->Count));
					 lvi->SubItems->Add(msgSts->TimeString);
					 lvi->SubItems->Add(msgSts->DataString);
				 }
				 finally {
					 Monitor::Exit(m_receiveMsgs->SyncRoot);
				 }
			 }

			 /// <summary>
			 /// Updates the "received-message" listView with the internal list of received message.
			 /// </summary>
			 void displayMessages()
			 {
				 ListViewItem ^lvi;   // listView item corresponding to a specific messageStatus

				 Monitor::Enter(m_receiveMsgs->SyncRoot);
				 // Loops through all the received messageStatus to update the display
				 for each(MessageStatus ^msgStatus in m_receiveMsgs)
				 {
					 // Checks that the data needs to be actualized
					 if (msgStatus->MarkedAsUpdated)
					 {
						 msgStatus->MarkedAsUpdated = false;
						 // Retrieves the listView corresponding to the messageStatus
						 lvi = listViewMsgs->Items[msgStatus->Position];
						 // Updates the listView item's fields
						 lvi->SubItems[0]->Text = msgStatus->SourceAddress;
						 lvi->SubItems[1]->Text = msgStatus->TargetAddress;
						 lvi->SubItems[2]->Text = msgStatus->RemoteAddress;
						 lvi->SubItems[3]->Text = msgStatus->CanIdType;
						 lvi->SubItems[4]->Text = msgStatus->MsgType;
						 lvi->SubItems[5]->Text = msgStatus->FormatType;
						 lvi->SubItems[6]->Text = msgStatus->TargetType;
						 lvi->SubItems[7]->Text = msgStatus->ResultString;
						 // Updates the Network Result color (red for an error)
						 if (msgStatus->CanTpMsg.RESULT != TPCANTPConfirmation::PCANTP_N_OK)
							 lvi->SubItems[7]->ForeColor = Color::Red;
						 else
							 lvi->SubItems[7]->ForeColor = lvi->ForeColor;
						 lvi->SubItems[8]->Text = msgStatus->LengthString;
						 lvi->SubItems[9]->Text = Convert::ToString(msgStatus->Count);
						 lvi->SubItems[10]->Text = msgStatus->TimeString;
						 lvi->SubItems[11]->Text = msgStatus->DataString;
					 }
				 }
				 Monitor::Exit(m_receiveMsgs->SyncRoot);
			 }

#pragma endregion

#pragma region Controllers handling thread to read message
			 /// <summary>
			 /// Main entry point for thread "read messages"
			 /// </summary>
			 void pctpReadThread()
			 {
				 UInt32 iBuffer;
				 TPCANTPStatus sts;

				 // Sets the handle of the Receive-Event.
				 iBuffer = Convert::ToUInt32(m_receiveEvent->SafeWaitHandle->DangerousGetHandle().ToInt32());
				 sts = CanTpApi::SetValue(m_pctpHandle, TPCANTPParameter::PCANTP_PARAM_RECEIVE_EVENT, iBuffer, sizeof(UInt32));
				 if (sts != TPCANTPStatus::PCANTP_ERROR_OK)
				 {
					 // Handles failure on the UI thread then aborts thread.
					 this->Invoke(m_readFailedDelegate, sts);
					 return;
				 }
				 // Loops while the "read thread" mode is selected
				 while (radioButtonMsgEvent->Checked)
				 {
					 // Waits for Receive-Event
					 if (m_receiveEvent->WaitOne(50))
						 // Process Receive-Event using .NET Invoke function
						 // in order to interact with Winforms UI (calling the 
						 // function readMessages)
						 this->Invoke(m_readDelegate);
				 }
			 }

			 /// <summary>
			 /// Handles failure while reading messages with a thread.
			 /// </summary>
			 /// <param name="sts"></param>
			 void readThreadFailed(TPCANTPStatus sts)
			 {
				 // Shows the error status.
				 checkCanTpStatus(sts);
				 // reverts to the default reading method.
				 radioButtonMsgTimer->PerformClick();
			 }

#pragma endregion

#pragma region Controllers handling miscellaneous UI updates.
			 /// <summary>
			 /// Checks a TPCANTPStatus value and shows a messageBox if the status is not OK.
			 /// </summary>
			 /// <param name="err">ISO-TP Status to check</param>
			 void checkCanTpStatus(TPCANTPStatus err)
			 {
				 if (err == TPCANTPStatus::PCANTP_ERROR_OK)
					 return;
				 MessageBox::Show(this, CanTpUtils::GetError(err) + " (" + Convert::ToString(err) + ")",
					 "CANTP Status", MessageBoxButtons::OK, MessageBoxIcon::Exclamation);
			 }


			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Args">List of arguments given to CANTP function (usage : {(int)var1, (int) var2, ... } </param>
			 /// <param name="p_Msg">Pointer on CAN Message structure</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, TPCANTPMsg^ p_Msg, ... array<Int32>^ p_Args)
			 {
				 String^ strOutMsg = "";
				 String^ strCallerName = "";
				 String^ strData = "";

				 UInt32 polynomialIndex = 0;
				 const UInt32 maxsize = 256;
				 UInt16 length = (UInt16)p_Args->GetLength(0);
				 array<Byte>^ datatab = gcnew array<Byte>(maxsize);
				 UInt32 result = 0;
				 UInt32 counter = 0;

#if _DEBUG_WRITE_CHECK_FILE
				 String ^checkFileName = "";
				 if (g_FileInitAlreadyDone == false)
				 {
					 // Init file to write result
					 String ^sTime = DateTime::Now.ToString("yyyy.MM.dd_HH.mm.ss");
					 checkFileName = "CLR-" + sTime + ".csv";
					 try
					 {
						 g_CheckFileToWrite = gcnew System::IO::StreamWriter(checkFileName);
						 g_CheckFileToWrite->WriteLine("CallerName;Result;Args_1;Args_2;Args_3;Args_4;Args_5;Args_6;Args_7;Args_8;Args_9;Args_10;Args_11");
						 g_CheckFileToWrite->Flush();
						 g_FileInitAlreadyDone = true;
					 }
					 catch (...) {};
				 }
#endif

				 // Get caller method name
				 strCallerName = GetCallerMethodName()->ToString();

				 // Polynomial calculation for unique result from Args
				 result += (++polynomialIndex) * p_Handle;
				 result += (++polynomialIndex) * (UInt32)p_Err;

				 strData = String::Format("Handle[{0}];Status[{1}]", p_Handle, (int)p_Err);
				 for (int i = 0; i < p_Args->GetLength(0); i++)
				 {
					 datatab[polynomialIndex++] = (Byte)(p_Args[i] * (polynomialIndex + 1));
					 result += (UInt32)(p_Args[i] * (polynomialIndex + 1));
					 strData = String::Format("{0};Arg_{1}[{2}]", strData, counter++, (int)p_Args[i]);
				 }


				 // If there is a message structure a CRC is calculated dans message is added in out String
				 if (p_Msg->LEN > 0)
				 {
					 result += (++polynomialIndex) * p_Msg->SA;
					 result += (++polynomialIndex) * p_Msg->TA;
					 result += (++polynomialIndex) * (UInt32)p_Msg->TA_TYPE;
					 result += (++polynomialIndex) * p_Msg->RA;
					 result += (++polynomialIndex) * (UInt32)p_Msg->IDTYPE;
					 result += (++polynomialIndex) * (UInt32)p_Msg->MSGTYPE;
					 result += (++polynomialIndex) * (UInt32)p_Msg->FORMAT;
					 result += (++polynomialIndex) * (UInt32)p_Msg->RESULT;
					 result += (++polynomialIndex) * p_Msg->LEN;

					 // All Data fields are used in case of bad data indexing during message construction
					 //for (int i = 0; i < 4095; i++) retVal += (++p_polynomeIndex) * p_canMsg.DATA[i];
					 // A CRC 16 is calculated on DATA to prevent LONG64 overflow with polynome on 4095 fields
					 // And not a CRC32 for perfomances improvement
					 result += crc16(p_Msg->DATA, p_Msg->LEN);
					 strData = String::Format("{0};SA[{1}];TA[{2}];TA_TYPE[{3}];RA[{4}];IDTYPE[{5}];MSGTYPE[{6}];FORMAT[{7}];RESULT[{8}];LEN[{9}];DATA[",
						 strData, p_Msg->SA, p_Msg->TA, (int)p_Msg->TA_TYPE, p_Msg->RA, (int)p_Msg->IDTYPE, (int)p_Msg->MSGTYPE, (int)p_Msg->FORMAT, (int)p_Msg->RESULT, p_Msg->LEN);
					 for (UInt32 i = 0; i < p_Msg->LEN; i++)
					 {
						 strData = String::Format("{0}{1}", strData, p_Msg->DATA[i].ToString("X2"));
					 }
					 strData = String::Format("{0}]", strData);
				 }

				 // Concat all Strings
				 strOutMsg = String::Format("{0};{1};{2}", strCallerName, result, strData);
#if _DEBUG_WRITE_CHECK_FILE
#if _DEBUG
				 Console::WriteLine(strOutMsg);
#endif
				 if (g_FileInitAlreadyDone == true)
				 {
					 // Write result in file
					 try {
						 g_CheckFileToWrite->WriteLine(strOutMsg);
						 g_CheckFileToWrite->Flush();
					 }
					 catch (...) {};
				 }
#endif

				 if (p_Err == TPCANTPStatus::PCANTP_ERROR_OK)
					 return;
				 MessageBox::Show(CanTpUtils::GetError(p_Err) + " (" + Convert::ToString(p_Err) + ")",
					 "CANTP Status", MessageBoxButtons::OK, MessageBoxIcon::Exclamation);
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Args">List of arguments given to CANTP function (usage : {(int)var1, (int) var2, ... } </param>
			 /// <param name="p_Msg">Pointer on CAN Message structure</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, ... array<Int32>^ p_Args)
			 {
				 TPCANTPMsg ^p_Msg = gcnew TPCANTPMsg();
				 p_Msg->RA = 0;
				 p_Msg->SA = 0;
				 p_Msg->TA = 0;
				 p_Msg->LEN = 0;
				 p_Msg->DATA = gcnew array<Byte>(4095);
				 p_Msg->FORMAT = TPCANTPFormatType::PCANTP_FORMAT_UNKNOWN;
				 p_Msg->IDTYPE = TPCANTPIdType::PCANTP_ID_CAN_11BIT;
				 p_Msg->MSGTYPE = TPCANTPMessageType::PCANTP_MESSAGE_UNKNOWN;
				 p_Msg->RESULT = TPCANTPConfirmation::PCANTP_N_ERROR;
				 p_Msg->TA_TYPE = TPCANTPAddressingType::PCANTP_ADDRESSING_UNKNOWN;

				 checkCanTpStatus(p_Handle, p_Err, p_Msg, p_Args);
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Msg">Characters buffer</param>
			 /// <param name="p_Parameter">Parameter</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, array<Byte>^ p_Msg)
			 {
				 checkCanTpStatus(p_Handle, p_Err, p_Msg, 0);
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Msg">Characters buffer</param>
			 /// <param name="p_Parameter">Parameter</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, array<Byte>^ p_Msg, Byte p_Parameter)
			 {
				 if (p_Msg->GetLength(0) != 0)
				 {
					 checkCanTpStatus(p_Handle, p_Err, p_Parameter, crc16(p_Msg, (UInt16)(p_Msg->GetLength(0))));
				 }
				 else
				 {
					 checkCanTpStatus(p_Handle, p_Err);
				 }
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Msg">Characters buffer</param>
			 /// <param name="p_Parameter">Parameter</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, StringBuilder^ p_Msg)
			 {
				 checkCanTpStatus(p_Handle, p_Err, p_Msg, (TPCANTPParameter)0);
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Msg">Characters buffer</param>
			 /// <param name="p_Parameter">Parameter</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, StringBuilder^ p_Msg, TPCANTPParameter p_Parameter)
			 {
				 if (p_Msg->Length != 0)
				 {
					 checkCanTpStatus(p_Handle, p_Err, (int)p_Parameter, crc16(System::Text::Encoding::UTF8->GetBytes(p_Msg->ToString()), (UInt16)(p_Msg->Length)));
				 }
				 else
				 {
					 checkCanTpStatus(p_Handle, p_Err);
				 }
			 }

			 /// <summary>
			 /// Check the status of CAN function result and give information to compare results in debug mode
			 /// </summary>
			 /// <param name="p_Handle">CAN Handle</param>
			 /// <param name="p_Err">CAN Status</param>
			 /// <param name="p_Mapping">Pointer on mapping structure</param>
			 static void checkCanTpStatus(TPCANTPHandle p_Handle, TPCANTPStatus p_Err, MappingStatus^ p_Mapping)
			 {
				 checkCanTpStatus(p_Handle, p_Err,
					 (int)p_Mapping->m_canId, (int)p_Mapping->m_canIdResponse,
					 (int)p_Mapping->m_canIdType, (int)p_Mapping->m_formatType, (int)p_Mapping->m_msgType,
					 p_Mapping->m_sourceAddr, p_Mapping->m_targetAddr, (int)p_Mapping->m_targetType, p_Mapping->m_remoteAddr);
			 }


			 /// <summary>
			 /// this is the CCITT CRC 16 polynomial X^16  + X^12  + X^5  + 1.
			 /// This works out to be 0x1021, but the way the algorithm works
			 /// lets us use 0x8408 (the reverse of the bit pattern).  The high
			 /// bit is always assumed to be set, thus we only use 16 bits to
			 /// represent the 17 bit value.
			 /// </summary>
			 /// <param name="p_data">Tab of BYTE</param>
			 /// <param name="p_length">Length of tab</param>
			 /// <returns>CRC 16</returns>
			 static UInt16 crc16(array<Byte>^ p_data, UInt16 p_length)
			 {
				 Byte i;
				 UInt32 indexData = 0;
				 UInt16 data;
				 UInt16 crc = 0xffff;
				 const UInt16 POLY = 0x8408;

				 if (p_length == 0)
					 return (UInt16)(~crc);

				 do
				 {
					 for (i = 0, data = (UInt16)(0xff & p_data[indexData++]);
						 i < 8;
						 i++, data >>= 1)
					 {
						 if (((crc & 0x0001) ^ (data & 0x0001)) != 0)
							 crc = (UInt16)((crc >> 1) ^ POLY);
						 else crc >>= 1;
					 }
				 } while (--p_length > 0);

				 crc = (UInt16)~crc;
				 data = crc;
				 crc = (UInt16)((crc << 8) | (data >> 8 & 0xff));

				 return (crc);
			 }

			 /// <summary>
			 /// Get caller name
			 /// </summary>
			 /// <returns>Return the name of the caller</returns>
			 static StringBuilder^ GetCallerMethodName() //ref string name)
			 {
				 int indexStackOK = 0;
				 System::Diagnostics::StackFrame^ frame = gcnew System::Diagnostics::StackFrame(0);
				 for (UInt32 i = 0; i < 5; i++)
				 {
					 frame = gcnew System::Diagnostics::StackFrame((int)i);
					 if ((frame->GetMethod()->Name != "checkCanTpStatus") && (frame->GetMethod()->Name != "GetCallerMethodName"))
					 {
						 indexStackOK = (int)i;
						 break;
					 }
				 }
				 return gcnew StringBuilder(frame->GetMethod()->Name);;
			 }

			 /// <summary>
			 /// Includes a new line of text into the information ListBox
			 /// </summary>
			 /// <param name="strMsg">Text to be included</param>
			 void includeTextMessage(String ^strMsg)
			 {
				 listBoxParamInfo->Items->Add(strMsg);
				 listBoxParamInfo->SelectedIndex = listBoxParamInfo->Items->Count - 1;
			 }
			 /// <summary>
			 /// First initialization of UI components of the "Connection" tab.
			 /// </summary>
			 void initializeUiConnection()
			 {
				 // fill combobox "comboBoxBaudrate"
				 comboBoxBaudrate->Items->Clear();
				 for each(TPCANTPBaudrate value in Enum::GetValues(TPCANTPBaudrate::typeid))
					 comboBoxBaudrate->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetBitrate(value), value));
				 comboBoxBaudrate->SelectedIndex = 2;
				 // fill combobox "comboBoxHwType"
				 comboBoxHwType->Items->Clear();
				 for each(TPCANTPHWType value in Enum::GetValues(TPCANTPHWType::typeid))
					 comboBoxHwType->Items->Add(gcnew ComboBoxItem(Enum::GetName(TPCANTPHWType::typeid, value), value));
				 // fill combobox "comboBoxIoPort"
				 comboBoxIoPort->Items->Clear();
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0100", 0x0100));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0120", 0x0120));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0140", 0x0140));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0200", 0x0200));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0220", 0x0220));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0240", 0x0240));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0260", 0x0260));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0278", 0x0278));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0280", 0x0280));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("02A0", 0x02A0));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("02C0", 0x02C0));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("02E0", 0x02E0));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("02E8", 0x02E8));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("02F8", 0x02F8));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0300", 0x0300));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0320", 0x0320));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0340", 0x0340));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0360", 0x0360));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0378", 0x0378));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("0380", 0x0380));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("03BC", 0x03BC));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("03E0", 0x03E0));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("03E8", 0x03E8));
				 comboBoxIoPort->Items->Add(gcnew ComboBoxItem("03F8", 0x03F8));
				 // fill combobox "comboBoxInterrupt"
				 comboBoxInterrupt->Items->Clear();
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("3", 3));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("4", 4));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("5", 5));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("7", 7));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("9", 9));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("10", 10));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("11", 11));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("12", 12));
				 comboBoxInterrupt->Items->Add(gcnew ComboBoxItem("15", 15));
				 // fill combobox "comboBoxChannel"
				 buttonHwRefresh_Click(this, EventArgs::Empty);
				 // select last item
				 comboBoxChannel->SelectedIndex = comboBoxChannel->Items->Count - 1;
			 }
			 /// <summary>
			 /// First initialization of UI components of the "Message" tab.
			 /// </summary>
			 void initializeUiTabMessages()
			 {
				 numericUpDownMsgLength_ValueChanged(this, EventArgs::Empty);
			 }
			 /// <summary>
			 /// First initialization of UI components of the "Parameter" tab.
			 /// </summary>
			 void initializeUiTabParameters()
			 {
				 TPCANTPParameter param;
				 // fill combobox "comboBoxParameter"
				 comboBoxParameter->Items->Clear();
				 param = TPCANTPParameter::PCANTP_PARAM_API_VERSION;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_CHANNEL_CONDITION;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_DEBUG;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));

				 param = TPCANTPParameter::PCANTP_PARAM_RECEIVE_EVENT;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_MSG_PENDING;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));

				 param = TPCANTPParameter::PCANTP_PARAM_BLOCK_SIZE;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_SEPARATION_TIME;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_WFT_MAX;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));

				 param = TPCANTPParameter::PCANTP_PARAM_PADDING_VALUE;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 param = TPCANTPParameter::PCANTP_PARAM_CAN_DATA_PADDING;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 //J1939 Priority
				 param = TPCANTPParameter::PCANTP_PARAM_J1939_PRIORITY;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
				 // DLC when FD is selected
				 param = TPCANTPParameter::PCANTP_PARAM_CAN_TX_DL;
				 comboBoxParameter->Items->Add(gcnew ComboBoxItem(CanTpUtils::GetParameter(param), param));
			 }
			 /// <summary>
			 /// Activates/deactivates the different controls of the main-form according
			 /// with the current connection status
			 /// </summary>
			 /// <param name="bConnected">Current status. True if connected, false otherwise</param>
			 void setConnectionStatus(bool bConnected)
			 {
				 // Connection components
				 buttonInit->Enabled = !bConnected;
				 buttonRelease->Enabled = bConnected;
				 buttonHwRefresh->Enabled = !bConnected;
				 comboBoxChannel->Enabled = !bConnected;
				 comboBoxBaudrate->Enabled = !bConnected;
				 comboBoxHwType->Enabled = !bConnected;
				 comboBoxIoPort->Enabled = !bConnected;
				 comboBoxInterrupt->Enabled = !bConnected;
				 // Parameters components
				 buttonParamReset->Enabled = bConnected;
				 buttonParamStatus->Enabled = bConnected;
				 comboBoxParameter_SelectedIndexChanged(this, EventArgs::Empty);
				 // Mappings components
				 buttonMappingAdd->Enabled = bConnected;
				 buttonMappingDel->Enabled = bConnected;
				 buttonMappingSample->Enabled = bConnected;
				 listViewMappings->Enabled = bConnected;
				 listViewMappings_SelectedIndexChanged(this, EventArgs::Empty);
				 // Messages components
				 buttonMsgRead->Enabled = bConnected;
				 buttonMsgWrite->Enabled = bConnected;
				 comboBoxMsgMapping->Enabled = bConnected;
				 listViewMsgs->Enabled = bConnected;
				 comboBoxMsgMapping_SelectedIndexChanged(this, EventArgs::Empty);

				 if (!bConnected)
					 // reload hardware configuration if NOT connected
					 comboBoxChannel_SelectedIndexChanged(this, EventArgs::Empty);
				 else
					 // update reading method if connected
					 radioButtonMsgRead_CheckedChanged(this, EventArgs::Empty);
			 }
			 /// <summary>
			 /// States if an ISO-TP channel is currently connected.
			 /// </summary>
			 /// <returns>true if a channel is connected.</returns>
			 bool isConnected() {
				 return m_pctpHandle != CanTpApi::PCANTP_NONEBUS;
			 }

			 bool readMappingFile()
			 {
				 MappingStatus^ mapping;
				 try
				 {
					 if (System::IO::File::Exists("Mappings.csv") == true)
					 {
						 // Open the file to read from.
						 array<String^>^ readText = System::IO::File::ReadAllLines("Mappings.csv");
						 bool skipFirstLine = true; // First line is CSV header
						 for each(String^ s in readText)
						 {
							 if (skipFirstLine == true)
							 {
								 skipFirstLine = false;
								 continue;
							 }
							 array<String^>^ allValues = s->Split(';');
							 if (allValues->Length == 9) // Mapping must have 9 elements to be valid
							 {
								 //            0      1                  2           3    4  5   6       7     8
								 //newLine = "CAN_ID;CAN_ID response;Target Type;ID Type;SA;TA;MsgType;Format;RA" + Environment.NewLine;
								 //mapping = new MappingStatus(0, 1, 3, 7, 6, 2, 4, 5, 8)
								 mapping = gcnew MappingStatus(Convert::ToInt32(allValues[0]),
									 Convert::ToInt32(allValues[1]),
									 (TPCANTPIdType)Convert::ToInt32(allValues[3]),
									 (TPCANTPFormatType)Convert::ToInt32(allValues[7]),
									 (TPCANTPMessageType)Convert::ToInt32(allValues[6]),
									 (TPCANTPAddressingType)Convert::ToInt32(allValues[2]),
									 Convert::ToByte(allValues[4]),
									 Convert::ToByte(allValues[5]),
									 Convert::ToByte(allValues[8]));
								 mappingsAdd(mapping);
								 mappingsChanged();
							 }
							 //m_mappings.Add(mapping);
						 }
					 }
				 }
				 catch (...) {};
				 return true;
			 }

#pragma endregion

	private: System::Void buttonMappingSave_Click(System::Object^  sender, System::EventArgs^  e) {
		try
		{
			String^ CSVHeader = gcnew String("CAN_ID;CAN_ID response;Target Type;ID Type;SA;TA;MsgType;Format;RA" + Environment::NewLine); //"";
			String^ newLine = gcnew String("");
			if (System::IO::File::Exists("Mappings.csv") == false)
			{
				//CSVHeader = "CAN_ID;CAN_ID response;Target Type;ID Type;SA;TA;MsgType;Format;RA"; // + Environment.NewLine;
			}
			System::IO::StreamWriter^ mappingFileWriter = gcnew System::IO::StreamWriter("Mappings.csv");
			mappingFileWriter->WriteLine(CSVHeader);
			for (int i = 5; i < m_mappings->Count; i++) // Skip 5 firsts defaults mappings
			{
				newLine = ((Int32)m_mappings[i]->m_canId).ToString() + ";" + ((Int32)m_mappings[i]->m_canIdResponse).ToString() + ";" + ((Int32)m_mappings[i]->m_targetType).ToString() +
					";" + ((Int32)m_mappings[i]->m_canIdType).ToString() + ";" + ((Int32)m_mappings[i]->m_sourceAddr).ToString() +
					";" + ((Int32)m_mappings[i]->m_targetAddr).ToString() + ";" + ((Int32)m_mappings[i]->m_msgType).ToString() +
					";" + ((Int32)m_mappings[i]->m_formatType).ToString() + ";" + ((Int32)m_mappings[i]->m_remoteAddr).ToString();
				mappingFileWriter->WriteLine(newLine);
			}
			mappingFileWriter->Close();
		}
		catch (...) {};
	}
	private: System::Void buttonMappingLoad_Click(System::Object^  sender, System::EventArgs^  e) {
		readMappingFile();
	}
	private: System::Void checkBoxCanFd_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
		bool bIsChecked = checkBoxCanFd->Checked;

		labelConnBaudrate->Visible = !bIsChecked;
		labelConnIoPort->Visible = !bIsChecked;
		labelConnHwType->Visible = !bIsChecked;
		labelConnInterrupt->Visible = !bIsChecked;

		comboBoxBaudrate->Visible = !bIsChecked;
		comboBoxIoPort->Visible = !bIsChecked;
		comboBoxHwType->Visible = !bIsChecked;
		comboBoxInterrupt->Visible = !bIsChecked;
		//Manage FD, BRS and Priority checkboxes (in messages tabulation)
		textBoxCanFdBitrate->Visible = bIsChecked;
		labelConnBitRate->Visible = bIsChecked;
		checkBoxFDMessage->Visible = bIsChecked;
		checkBoxBRS->Visible = bIsChecked;
		checkBoxFDMessage->Checked = false;
		checkBoxHasPriority->Checked = false;
		checkBoxBRS->Checked = false;
		ManageUIForFD(bIsChecked);
	}
			 /// <summary>
			 /// Manage FD checkboxes when FD support is checked
			 /// </summary>
	private: System::Void ManageUIForFD(bool p_state)
	{
		checkBoxBRS->Visible = p_state;
		checkBoxFDMessage->Visible = p_state;
		checkBoxBRS->Enabled = !p_state;
		checkBoxFDMessage->Enabled = p_state;
	}
	private: System::Void checkBoxFDMessage_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
		checkBoxBRS->Enabled = checkBoxFDMessage->Checked == true;
	}
	private: System::Void checkBoxHasPriority_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
		numericUpDownPriority->Enabled = checkBoxHasPriority->Checked;
	}
	};
}

